#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-1pzZ4CwKOyu3FksT9E713L
key:                  arch-hs-0.11.1.0-1pzZ4CwKOyu3FksT9E713L
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  9f75d4724edb72cd30711bd94497d369
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-1pzZ4CwKOyu3FksT9E713L
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.6.3.0 Diff-0.4.1-7DJ54PO7amxJCKVFCJguu4
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    algebraic-graphs-0.7-JnJ1dRaFIjYHZiJfMEzFHl
    arch-web-0.2-68Gbo4uVYcy8keUnNpcZ56 base-4.16.4.0
    bytestring-0.11.4.0 conduit-1.3.6-6olN0R4zhzQGfJxY5P1sQG
    conduit-extra-1.3.6-DNMogv3hOWO1ZuiF0M3PeA containers-0.6.5.1
    deepseq-1.4.6.1 directory-1.3.6.2 filepath-1.4.2.2
    hackage-db-2.1.3-Gs72talbvevIoZqNPBDWNI
    http-client-0.7.17-DzkkR0N3yiTIx1C6IcWQ7J
    http-client-tls-0.3.6.3-2EQqEGNQgqBeXR2SFRRfB
    megaparsec-9.6.1-xFWwysPvLWIMfIZXM34tr
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6
    neat-interpolation-0.5.1.4-CZatqGc70tS6dAPTSqaR7a
    optparse-simple-0.1.1.4-4i0f9D0vvmpBdvpAoaVypf
    polysemy-1.9.2.0-J2pimBhv8dUfCMm7CWXi1
    prettyprinter-1.7.1-9qid7zuo3B05OoqIIBWgnL
    prettyprinter-ansi-terminal-1.1.3-LWMhohC2bf65OdaY6HUJHG
    servant-client-0.20-BI2fhY3OzqL1BNj0dXdmWE
    split-0.2.5-D8Q5hs7UAOeFSfUt4jgpO4
    tar-conduit-0.4.1-CXi8gtNnroh7iMI2pNOvWq template-haskell-2.18.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

