#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-ghc
version:              1.8.1
visibility:           public
id:                   clash-ghc-1.8.1-Jqz0E7qRlKe8B5OZFhsAFV
key:                  clash-ghc-1.8.1-Jqz0E7qRlKe8B5OZFhsAFV
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  ba200f263d34a1796f67e17af5a35afc
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.Leak Clash.GHCi.UI Clash.GHCi.UI.Info
    Clash.GHCi.UI.Monad Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Paths_clash_ghc
    Clash.GHCi.Util Clash.GHCi.UI.Tags

import-dirs:          /usr/lib/ghc-9.2.8/site-local/clash-ghc-1.8.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/clash-ghc-1.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/clash-ghc
hs-libraries:         HSclash-ghc-1.8.1-Jqz0E7qRlKe8B5OZFhsAFV
depends:
    Cabal-3.6.3.0 array-0.5.4.0 base-4.16.4.0 bytestring-0.11.4.0
    clash-lib-1.8.1-Bg0vTDMsIzt7oIuc0iXViK
    clash-prelude-1.8.1-FVaprtogMECKZ7b472FtiD
    concurrent-supply-0.1.8-3OpYSG4Qjm74lJEyXmGJB7 containers-0.6.5.1
    data-binary-ieee754-0.4.4-5RBO9sqtqwKK43ihLnlB61 deepseq-1.4.6.1
    directory-1.3.6.2 exceptions-0.10.4
    extra-1.7.16-HmT1ExbMa8s7Fr43bhn74d filepath-1.4.2.2 ghc-9.2.8
    ghc-bignum-1.2 ghc-boot-9.2.8 ghc-prim-0.8.0
    ghc-typelits-extra-0.4.4-GVquMQQWW2DJsuzWUFx1aI
    ghc-typelits-knownnat-0.7.8-IEgtQDKGoSQCxoboywb2EB
    ghc-typelits-natnormalise-0.7.8-2Y50M9bR3uU8qEOtqpAprR ghci-9.2.8
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj haskeline-0.8.2
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7 mtl-2.2.2
    primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl process-1.6.16.0
    reflection-2.1.8-HzL1Up6DlBhA3BKxwRzUkG
    split-0.2.5-D8Q5hs7UAOeFSfUt4jgpO4
    string-interpolate-0.3.4.0-5Ws3COJGwR537UBRNVUzaR
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 uniplate-1.6.13-CbgRsq6vXtfJZv6A35mNTh
    unix-2.7.2.2 unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

