#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 glirc
version:              2.39.0.1
visibility:           public
id:                   glirc-2.39.0.1-JdWKOWJef3QGDO4MCuglLG
key:                  glirc-2.39.0.1-JdWKOWJef3QGDO4MCuglLG
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  b7df47aa356dc054f5bf29e29158c022
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Window
    Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.Digraphs Client.View.Help
    Client.View.IgnoreList Client.View.KeyMap Client.View.MaskList
    Client.View.Mentions Client.View.Messages Client.View.Palette
    Client.View.RtsStats Client.View.UrlSelection Client.View.UserList
    Client.View.Windows

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.2.8/site-local/glirc-2.39.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/glirc-2.39.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.39.0.1-JdWKOWJef3QGDO4MCuglLG
include-dirs:         /usr/lib/ghc-9.2.8/site-local/glirc-2.39.0.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.7-ICmH9Hcxknk4vV99rzKcjd
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI base-4.16.4.0
    base64-bytestring-1.2.1.0-IROdBrGh8de3SyeGv4rKYj
    bytestring-0.11.4.0 config-schema-1.3.0.0-8Cg3CSty0X6KYB64FGqz9E
    config-value-0.8.3-8yCRuGm4wH18pEPQuVa8HA containers-0.6.5.1
    curve25519-0.2.8-L686OT02AHFBsOH1GDQOl directory-1.3.6.2
    filepath-1.4.2.2 free-5.1.10-InRordVHVEk5oREFazAoui
    githash-0.1.6.3-6jEugtinkaUIJMpyUWd9W9
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    hookup-0.8-E4h8zocOUop1JfGcieaKsR
    irc-core-2.11-D9awfA6IqD6LTOH4bNG8ph
    kan-extensions-5.2.6-D733ZjcYNtnEJkADwZoexO
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7
    network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs process-1.6.16.0
    psqueues-0.2.8.0-857AP9ODns1DOEKz6NGYnM
    random-1.2.1.2-LilJ2o1ueBgJ3oDFJkkk0o
    regex-tdfa-1.3.2.2-743XGAHrGLPIAyhrr2nNbU
    split-0.2.5-D8Q5hs7UAOeFSfUt4jgpO4 stm-2.5.0.2
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN
    vty-5.39-HhNImdH3gT44hZfQzYyd5p

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

