#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
key:                  aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  dadb67061b562078c98cc09a6387b62c
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.2.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
depends:
    OneTuple-0.4.1.1-Fzf8innqem9KWSxEnQPUoh
    QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI base-4.16.4.0
    base-compat-batteries-0.12.2-Hlzktlwsu2M7guzl1w4Dz3
    bytestring-0.11.4.0 containers-0.6.5.1
    data-fix-0.3.2-FGkTCFWnE3E5Wykr5tvlhN deepseq-1.4.6.1
    dlist-1.0-HCxoMn9TirQDgPCFxho7O exceptions-0.10.4
    generically-0.1.1-JMiBGdLJUYCDi0nkPCwFlG ghc-prim-0.8.0
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    indexed-traversable-0.1.4-6hGnPWNuqXlFS0NzZXy7sq
    primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    semialign-1.2.0.1-1mlh38qxy80EyVpT96yhYZ
    strict-0.4.0.1-7vHjqer2uEZJIl7jZqLEWQ
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg template-haskell-2.18.0.0
    text-1.2.5.0 text-short-0.1.6-1LbBtFl8nZt2KELkxcBYvU
    th-abstraction-0.4.5.0-FQrzhXbdvQX3Z0wTw3euNu
    these-1.1.1.1-1x10Q8jmJcG5CN0o6q3A0h time-1.11.1.1
    time-compat-1.9.6.1-HEeLlSu8aB57PQ9XcXxOia
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    uuid-types-1.0.5.1-8ydgA9GBSMG7GlP7QxulKE
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN
    witherable-0.4.2-2riHnHd4PN2LWjwTngaskg

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

