#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cheapskate
version:              0.1.1.2
visibility:           public
id:                   cheapskate-0.1.1.2-1AqVcT2CxpX5MOxT4FXsdk
key:                  cheapskate-0.1.1.2-1AqVcT2CxpX5MOxT4FXsdk
license:              BSD-3-Clause
copyright:            (C) 2012-2013 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             http://github.com/jgm/cheapskate
synopsis:             Experimental markdown processor.
description:
    This is an experimental Markdown processor in pure
    Haskell.  It aims to process Markdown efficiently and in
    the most forgiving possible way.  It is designed to deal
    with any input, including garbage, with linear
    performance.  Output is sanitized by default for
    protection against XSS attacks.

    Several markdown extensions are implemented, including
    fenced code blocks, significant list start numbers, and
    autolinked URLs.  See README.markdown for details.

category:             Text
abi:                  014fed238cf48d483188eb575f942b32
exposed:              True
exposed-modules:
    Cheapskate Cheapskate.Html Cheapskate.Parse Cheapskate.Types

hidden-modules:
    Cheapskate.Util Cheapskate.Inlines Cheapskate.ParserCombinators
    Paths_cheapskate

import-dirs:          /usr/lib/ghc-9.2.8/site-local/cheapskate-0.1.1.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/cheapskate-0.1.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cheapskate
hs-libraries:         HScheapskate-0.1.1.2-1AqVcT2CxpX5MOxT4FXsdk
depends:
    base-4.16.4.0 blaze-html-0.9.2.0-C4ZBPt0ygub3tdDLZwenWL
    containers-0.6.5.1 data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS
    deepseq-1.4.6.1 mtl-2.2.2 syb-0.7.2.4-89doc1zYrrWCF1u4CgIEo3
    text-1.2.5.0 uniplate-1.6.13-CbgRsq6vXtfJZv6A35mNTh
    xss-sanitize-0.3.7.2-765kyFZYcWcL5kVNP1F4By

haddock-interfaces:   /usr/share/doc/haskell-cheapskate/html/cheapskate.haddock
haddock-html:         /usr/share/doc/haskell-cheapskate/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

