#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 criterion
version:              1.6.1.0
visibility:           public
id:                   criterion-1.6.1.0-33iGFNrRtHuGk17YCBiWoq
key:                  criterion-1.6.1.0-33iGFNrRtHuGk17YCBiWoq
license:              BSD-3-Clause
copyright:            2009-2016 Bryan O'\''Sullivan and others
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             http://www.serpentine.com/criterion
synopsis:             Robust, reliable performance measurement and analysis
description:
    This library provides a powerful but simple way to measure software
    performance.  It provides both a framework for executing and
    analysing benchmarks and a set of driver functions that makes it
    easy to build and run benchmarks, and to analyse their results.

    The fastest way to get started is to read the
    <http://www.serpentine.com/criterion/tutorial.html online tutorial>,
    followed by the documentation and examples in the "Criterion.Main"
    module.

    For examples of the kinds of reports that criterion generates, see
    <http://www.serpentine.com/criterion the home page>.

category:             Development, Performance, Testing, Benchmarking
abi:                  d154a5d5cc39ac7ba0e830da42fb2d68
exposed:              True
exposed-modules:
    Criterion Criterion.Analysis Criterion.IO Criterion.IO.Printf
    Criterion.Internal Criterion.Main Criterion.Main.Options
    Criterion.Monad Criterion.Report Criterion.Types

hidden-modules:
    Criterion.Main.Options.Internal Criterion.Monad.Internal
    Paths_criterion

import-dirs:          /usr/lib/ghc-9.2.8/site-local/criterion-1.6.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/criterion-1.6.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-criterion
hs-libraries:         HScriterion-1.6.1.0-33iGFNrRtHuGk17YCBiWoq
depends:
    Glob-0.10.2-IttgZQd8QbwIoW4wWo8qwk
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9 base-4.16.4.0
    base-compat-batteries-0.12.2-Hlzktlwsu2M7guzl1w4Dz3 binary-0.8.9.0
    binary-orphans-1.0.4.1-8XRdAgqBBAqGfOZkaTX8kg bytestring-0.11.4.0
    cassava-0.5.3.2-KYxSsEiPscTI84btZ9NDhj
    code-page-0.2.1-2Ge3Prwpi0K5qObDyqbdK0 containers-0.6.5.1
    criterion-measurement-0.2.2.0-Q0zPFFsNrp7DhYEhctH85 deepseq-1.4.6.1
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.2
    js-chart-2.9.4.1-6hvGzEdkELJ3JFGr8TxcsX
    microstache-1.0.2.3-4mqUjX7iUdXDbTikQx08YG mtl-2.2.2
    mwc-random-0.15.1.0-E3ICnwx8GLI7N3W9UJxHMV
    optparse-applicative-0.17.1.0-G3d2ugE95DU3DYNCy08LZF
    parsec-3.1.15.0 statistics-0.16.2.1-39qm4aIEy4c4b8QvxkOcFN
    text-1.2.5.0 time-1.11.1.1 transformers-0.5.6.2
    transformers-compat-0.7.2-9ApmiRwA3hS7UuQpOomcS
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN
    vector-algorithms-0.9.0.2-AifrHUwW4R1Lt5bHdhxMQV

haddock-interfaces:   /usr/share/doc/haskell-criterion/html/criterion.haddock
haddock-html:         /usr/share/doc/haskell-criterion/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

