#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-api-tests
version:              0.3
visibility:           public
id:                   crypto-api-tests-0.3-2aUHsZrVdoU9eSxj1F1V1d
key:                  crypto-api-tests-0.3-2aUHsZrVdoU9eSxj1F1V1d
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             http://trac.haskell.org/crypto-api/wiki
synopsis:             A test framework and KATs for cryptographic operations.
description:
    A test framework for hash and cipher operations using
    the crypto-api interface.  Known answer tests (KATs)
    for common cryptographic algorithms are included.
    Patches welcome (both adding KATs for more algorithms
    or property tests for classes of algorithms).

category:             Data, Cryptography
abi:                  8c81d3b4525ee78329a7e871baaa7fba
exposed:              True
exposed-modules:
    Test.AES Test.Crypto Test.HMAC Test.MD5 Test.ParseNistKATs Test.SHA
    Test.TwoFish

hidden-modules:       Paths_crypto_api_tests
import-dirs:          /usr/lib/ghc-9.2.8/site-local/crypto-api-tests-0.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/crypto-api-tests-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-api-tests
hs-libraries:         HScrypto-api-tests-0.3-2aUHsZrVdoU9eSxj1F1V1d
depends:
    HUnit-1.6.2.0-8V4cpd2vyM7I9OG8MrEdHy
    QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2 base-4.16.4.0
    bytestring-0.11.4.0 cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    crypto-api-0.13.3-95IFBy4WvL6L3p6UFm5MLc directory-1.3.6.2
    filepath-1.4.2.2 test-framework-0.8.2.0-8mZQzkucQG4Fsr88CfEGOC
    test-framework-hunit-0.3.0.2-64nP9rq3acf4kOhu60gItb
    test-framework-quickcheck2-0.3.0.5-5mgVbRdqxSzEizKu8UMDA5

haddock-interfaces:
    /usr/share/doc/haskell-crypto-api-tests/html/crypto-api-tests.haddock

haddock-html:         /usr/share/doc/haskell-crypto-api-tests/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

