#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 feed
version:              1.3.2.1
visibility:           public
id:                   feed-1.3.2.1-Dx2sT1JLdXi4ZUh5Y4pmBW
key:                  feed-1.3.2.1-Dx2sT1JLdXi4ZUh5Y4pmBW
license:              BSD-3-Clause
maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Sigbjorn Finne <sof@forkIO.com>
homepage:             https://github.com/haskell-party/feed
synopsis:             Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
description:
    Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.

    To help working with the multiple feed formats we'\''ve
    ended up with, this set of modules provides parsers,
    pretty printers and some utility code for querying
    and just generally working with a concrete representation
    of feeds in Haskell.

    See here for an example of how to create an Atom feed:
    <https://github.com/haskell-party/feed/blob/master/tests/Example/CreateAtom.hs>

    For basic reading and editing of feeds, consult
    the documentation of the Text.Feed.* hierarchy.

category:             Text
abi:                  9f9615176f3e3cf0c8b0af6c7d5ba9d8
exposed:              True
exposed-modules:
    Text.Atom.Feed Text.Atom.Feed.Export Text.Atom.Feed.Import
    Text.Atom.Feed.Link Text.Atom.Feed.Validate Text.Atom.Pub
    Text.Atom.Pub.Export Text.DublinCore.Types Text.Feed.Constructor
    Text.Feed.Export Text.Feed.Import Text.Feed.Query
    Text.Feed.Translate Text.Feed.Types Text.Feed.Util Text.RSS.Export
    Text.RSS.Import Text.RSS.Syntax Text.RSS1.Export Text.RSS1.Import
    Text.RSS1.Syntax Text.RSS1.Utils

hidden-modules:       Data.Text.Util Data.XML.Compat
import-dirs:          /usr/lib/ghc-9.2.8/site-local/feed-1.3.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/feed-1.3.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-feed
hs-libraries:         HSfeed-1.3.2.1-Dx2sT1JLdXi4ZUh5Y4pmBW
depends:
    base-4.16.4.0 base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd
    bytestring-0.11.4.0 old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7
    old-time-1.1.0.4-Dlc8YwGlkPi2Y3VNXkrOFg
    safe-0.3.21-41ZPWazUMNgR08x0DBIts text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI
    xml-conduit-1.9.1.3-GY3EuCjZuJf7uAN9wBV66B
    xml-types-0.3.8-LZyzf9bLT8K9kdiyyQ9IUF

haddock-interfaces:   /usr/share/doc/haskell-feed/html/feed.haddock
haddock-html:         /usr/share/doc/haskell-feed/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

