#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 fingertree
version:              0.1.5.0
visibility:           public
id:                   fingertree-0.1.5.0-BJfLF3cC2IH9TyQaIR6o3F
key:                  fingertree-0.1.5.0-BJfLF3cC2IH9TyQaIR6o3F
license:              BSD-3-Clause
copyright:            (c) 2006 Ross Paterson, Ralf Hinze
maintainer:           Ross Paterson <R.Paterson@city.ac.uk>
synopsis:             Generic finger-tree structure, with example instances
description:
    A general sequence representation with arbitrary
    annotations, for use as a base for implementations of
    various collection types, with examples, as described
    in section 4 of

    * Ralf Hinze and Ross Paterson,
    \"Finger trees: a simple general-purpose data structure\",
    /Journal of Functional Programming/ 16:2 (2006) pp 197-217.
    <http://staff.city.ac.uk/~ross/papers/FingerTree.html>

    For a tuned sequence type, see @Data.Sequence@ in the
    @containers@ package, which is a specialization of
    this structure.

category:             Data Structures
abi:                  20df8765c05bb6e1cd491ee7676491dc
exposed:              True
exposed-modules:
    Data.FingerTree Data.IntervalMap.FingerTree
    Data.PriorityQueue.FingerTree

import-dirs:          /usr/lib/ghc-9.2.8/site-local/fingertree-0.1.5.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/fingertree-0.1.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-fingertree
hs-libraries:         HSfingertree-0.1.5.0-BJfLF3cC2IH9TyQaIR6o3F
depends:              base-4.16.4.0
haddock-interfaces:   /usr/share/doc/haskell-fingertree/html/fingertree.haddock
haddock-html:         /usr/share/doc/haskell-fingertree/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

