#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 generic-lens-lite
version:              0.1.1
visibility:           public
id:                   generic-lens-lite-0.1.1-GULWG5BLcji7nfsp1xeMeq
key:                  generic-lens-lite-0.1.1-GULWG5BLcji7nfsp1xeMeq
license:              BSD-3-Clause
copyright:            Copyright (c) 2019 Edward Kmett, 2020 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Edward Kmett, Csongor Kiss, Oleg Grenrus
homepage:             https://github.com/phadej/generic-lens-lite
synopsis:             Monomorphic field lens like with generic-lens
description:
    Derivation of (monomorphic, i.e. not type-changing) lens, like generic-lens.

    The package have minimal dependecies and minimal API:

    @
    class HasField (name :: Symbol) r a | name r -> a
    field :: HasField name r a => Lens'\'' r a
    @

category:             Lens, Generics
abi:                  9bb3dee112df607689db5576bc437b56
exposed:              True
exposed-modules:      Data.Generics.Lens.Lite
hidden-modules:       Data.Functor.Confusing
import-dirs:          /usr/lib/ghc-9.2.8/site-local/generic-lens-lite-0.1.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/generic-lens-lite-0.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-generic-lens-lite
hs-libraries:         HSgeneric-lens-lite-0.1.1-GULWG5BLcji7nfsp1xeMeq
depends:              base-4.16.4.0
haddock-interfaces:
    /usr/share/doc/haskell-generic-lens-lite/html/generic-lens-lite.haddock

haddock-html:         /usr/share/doc/haskell-generic-lens-lite/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

