#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 haddock-library
version:              1.11.0
visibility:           public
id:                   haddock-library-1.11.0-B3HO50AH5Zw7Afy9Gl7Yu5
key:                  haddock-library-1.11.0-B3HO50AH5Zw7Afy9Gl7Yu5
license:              BSD-2-Clause
maintainer:
    Alec Theriault <alec.theriault@gmail.com>, Alex Biehl <alexbiehl@gmail.com>, Simon Hengel <sol@typeful.net>, Mateusz Kowalczyk <fuuzetsu@fuuzetsu.co.uk>

homepage:             http://www.haskell.org/haddock/
synopsis:             Library exposing some functionality of Haddock.
description:
    Haddock is a documentation-generation tool for Haskell
    libraries. These modules expose some
    functionality of it without pulling in the GHC
    dependency. Please note that the API is likely
    to change so be sure to specify upper bounds in
    your projects. For interacting with Haddock
    itself, see the [haddock package](https://hackage.haskell.org/package/haddock).

category:             Documentation
abi:                  e42aa45c4eb0dcfd164b098ca45832c5
exposed:              True
exposed-modules:
    Documentation.Haddock.Doc Documentation.Haddock.Markup
    Documentation.Haddock.Parser Documentation.Haddock.Types

hidden-modules:
    CompatPrelude Documentation.Haddock.Parser.Util
    Documentation.Haddock.Parser.Monad
    Documentation.Haddock.Parser.Identifier

import-dirs:          /usr/lib/ghc-9.2.8/site-local/haddock-library-1.11.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/haddock-library-1.11.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-haddock-library
hs-libraries:         HShaddock-library-1.11.0-B3HO50AH5Zw7Afy9Gl7Yu5
depends:
    base-4.16.4.0 containers-0.6.5.1 parsec-3.1.15.0 text-1.2.5.0

haddock-interfaces:
    /usr/share/doc/haskell-haddock-library/html/haddock-library.haddock

haddock-html:         /usr/share/doc/haskell-haddock-library/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

