#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-lib
version:              1.32.1
visibility:           public
id:                   hledger-lib-1.32.1-Cl04cj6hwLr8YY57UmJfHC
key:                  hledger-lib-1.32.1-Cl04cj6hwLr8YY57UmJfHC
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  d7d9e64739f5b6564a37185c18a75d20
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader Hledger.Read.CsvUtils
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-lib-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-lib-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.32.1-Cl04cj6hwLr8YY57UmJfHC
depends:
    Decimal-0.5.2-IyyiL7sGU7tBzBWwGViQxZ
    Glob-0.10.2-IttgZQd8QbwIoW4wWo8qwk
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    aeson-pretty-0.8.10-5TSYkD8Co5LLMI8e0zAoII
    ansi-terminal-0.11.5-GmxlGl1eC6rGTjWL8Yprft array-0.5.4.0
    base-4.16.4.0 base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd
    blaze-markup-0.8.3.0-F62q6tKjBbGDf7FwMvopea bytestring-0.11.4.0
    call-stack-0.4.0-7Kj6UtaYY94JDoMxAZHX8y
    cassava-0.5.3.2-KYxSsEiPscTI84btZ9NDhj
    cassava-megaparsec-2.1.1-7Fh0xY49qX5LPxdhItqOHt
    cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    colour-2.3.6-KDhjTRIL7rnBhoKfQ21QbO containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS deepseq-1.4.6.1
    directory-1.3.6.2 doclayout-0.4.0.1-4oSpukljPRO4lTcqY6b6gK
    extra-1.7.16-HmT1ExbMa8s7Fr43bhn74d
    file-embed-0.0.15.0-4hNEx1vJ7JTC58fR03LKND filepath-1.4.2.2
    hashtables-1.3.1-KMy6krt0MkJGoJkMgpnCWV
    megaparsec-9.6.1-xFWwysPvLWIMfIZXM34tr
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6 mtl-2.2.2
    pager-0.1.1.0-GMqlbmRh8V7DLAo9DnlFsu
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    pretty-simple-4.1.2.0-aemf95GDbcJZS8DJ9CNZc
    regex-tdfa-1.3.2.2-743XGAHrGLPIAyhrr2nNbU
    safe-0.3.21-41ZPWazUMNgR08x0DBIts
    tabular-0.2.2.8-95p3h1QIWwyCocci2BuF7w
    tasty-1.4.3-CfIBZQM3K237yv93el2PCn
    tasty-hunit-0.10.1-Ft7IXBQwHwoF9bmw9SZtNS template-haskell-2.18.0.0
    terminal-size-0.3.4-7GJNKkuDjwr8c9rYP2Bu9E text-1.2.5.0
    text-ansi-0.2.1.1-Gd4StowABUXC4X4V2zCfve time-1.11.1.1
    timeit-2.0-FPerWVMxZElJkpHtTsXEJ4 transformers-0.5.6.2
    uglymemo-0.1.0.1-8CUhCtOyIfIKj16OA2DPKD
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

