#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-1pWCU4OyRxoBnZPRz6Uv3d
key:                  hOpenPGP-2.9.8-1pWCU4OyRxoBnZPRz6Uv3d
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  be79da3d1626f5023d596ff5034a1b54
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-1pWCU4OyRxoBnZPRz6Uv3d
depends:
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    asn1-encoding-0.9.6-GAq2QlCqcbdGlIErejW67k
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI base-4.16.4.0
    base16-bytestring-1.0.2.0-BfU7bG0tjnC37zYxX4slQA
    bifunctors-5.6-K6PUy59ylq426ZXT29Buli binary-0.8.9.0
    binary-conduit-1.3.1-2puyCff7D6Q7tmFzMVbE50 bytestring-0.11.4.0
    bz2-1.0.1.1-6oKm6nymXgOL5mRawi1lTI
    conduit-1.3.6-6olN0R4zhzQGfJxY5P1sQG
    conduit-extra-1.3.6-DNMogv3hOWO1ZuiF0M3PeA containers-0.6.5.1
    crypto-cipher-types-0.0.9-JlEUy6YMnlQJGxVQmgyp8z
    cryptonite-0.30-HEkNV1IKVtLAPqzqnhGNTC
    errors-2.3.0-12hMNP7trtrANZNU86WSQi
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    incremental-parser-0.5.1-FXMSszAG0hlF5mADakdyuE
    ixset-typed-0.5.1.0-645ZNccDdMPC63wkyVARwc
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    monad-loops-0.4.3-1PoLx7GFY2f6JjKzBe0o6E
    nettle-0.3.1.1-IesfSaYKwdg21K60p9ny7B
    network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR
    openpgp-asciiarmor-0.1.2-BGcbDukCdvR4i64defqfsx
    prettyprinter-1.7.1-9qid7zuo3B05OoqIIBWgnL
    resourcet-1.2.6-Lqb3m6tuOhHIikJo8Ch6Wd
    split-0.2.5-D8Q5hs7UAOeFSfUt4jgpO4 text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    transformers-0.5.6.2 unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    zlib-0.6.3.0-CuOO7n4zc2g8TBZxjplZPM

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

