#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslogger
version:              1.3.1.1
visibility:           public
id:                   hslogger-1.3.1.1-AaFqNA3CZ3wF1V1MzkMbBe
key:                  hslogger-1.3.1.1-AaFqNA3CZ3wF1V1MzkMbBe
license:              BSD-3-Clause
copyright:
    Copyright (c) 2004-2018 John Goerzen
    , (c) 2019      Herbert Valerio Riedel

maintainer:           https://github.com/haskell-hvr/hslogger
author:               John Goerzen
homepage:             https://github.com/haskell-hvr/hslogger/wiki
synopsis:             Versatile logging framework
description:
    @hslogger@ is a logging framework for Haskell, roughly similar
    to [Python'\''s logging module](https://docs.python.org/2/library/logging.html).

    @hslogger@ lets each log message have a priority and source be associated
    with it.  The programmer can then define global handlers that route
    or filter messages based on the priority and source.  @hslogger@ also
    has a [Syslog](https://tools.ietf.org/html/rfc5424) handler built in.

category:             Interfaces
abi:                  a6cd71a648a4e4918b0362ee07af5ac7
exposed:              True
exposed-modules:
    System.Log System.Log.Formatter System.Log.Handler
    System.Log.Handler.Growl System.Log.Handler.Log4jXML
    System.Log.Handler.Simple System.Log.Handler.Syslog
    System.Log.Logger

hidden-modules:       UTF8
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hslogger-1.3.1.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hslogger-1.3.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslogger
hs-libraries:         HShslogger-1.3.1.1-AaFqNA3CZ3wF1V1MzkMbBe
depends:
    base-4.16.4.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs
    network-bsd-2.8.1.0-EX3zi0DvFYb6HIrJ1w23Qb
    old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7 time-1.11.1.1
    unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-hslogger/html/hslogger.haddock
haddock-html:         /usr/share/doc/haskell-hslogger/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

