#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hspec
version:              2.10.9
visibility:           public
id:                   hspec-2.10.9-8EHAZD5WgY7w8NSfyDurV
key:                  hspec-2.10.9-8EHAZD5WgY7w8NSfyDurV
license:              MIT
copyright:
    (c) 2011-2023 Simon Hengel,
    (c) 2011-2012 Trystan Spangler,
    (c) 2011 Greg Weber

maintainer:           Simon Hengel <sol@typeful.net>
stability:            experimental
homepage:             https://hspec.github.io/
synopsis:             A Testing Framework for Haskell
description:
    Hspec is a testing framework for Haskell.  Some of Hspec'\''s distinctive
    features are:

    * a friendly DSL for defining tests

    * integration with QuickCheck, SmallCheck, and HUnit

    * parallel test execution

    * automatic discovery of test files

    The Hspec Manual is at <https://hspec.github.io/>.

category:             Testing
abi:                  b63cdda383936b65b3377fe84d917c9f
exposed:              True
exposed-modules:
    Test.Hspec Test.Hspec.Discover Test.Hspec.Formatters
    Test.Hspec.QuickCheck Test.Hspec.Runner

hidden-modules:       Paths_hspec
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hspec-2.10.9
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hspec-2.10.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hspec
hs-libraries:         HShspec-2.10.9-8EHAZD5WgY7w8NSfyDurV
depends:
    QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2 base-4.16.4.0
    hspec-core-2.10.9-IqhoinBtbd5CIQeE27RI4K
    hspec-discover-2.10.9-2xBOgsOLkiLFzsXbKcNNcf
    hspec-expectations-0.8.3-1zJ9Bt2UKIO1izJ8suxZW5

haddock-interfaces:   /usr/share/doc/haskell-hspec/html/hspec.haddock
haddock-html:         /usr/share/doc/haskell-hspec/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

