#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HsYAML-aeson
version:              0.2.0.1
visibility:           public
id:                   HsYAML-aeson-0.2.0.1-8Oy2FVkLGNvA4GMyoaOsmF
key:                  HsYAML-aeson-0.2.0.1-8Oy2FVkLGNvA4GMyoaOsmF
license:              GPL-2.0-or-later
copyright:            2018-2019 Herbert Valerio Riedel
maintainer:           hvr@gnu.org, Andreas Abel
author:               Herbert Valerio Riedel
synopsis:             JSON to YAML Adapter
description:
    The [YAML 1.2](https://yaml.org/spec/1.2/spec.html) format provides
    a much richer data-model and feature-set
    than the [JavaScript Object Notation (JSON)](https://tools.ietf.org/html/rfc7159) format.
    However, sometimes it'\''s desirable to ignore the extra capabilities
    and treat YAML as if it was merely a more convenient markup format
    for humans to write JSON data. To this end this module provides a
    compatibility layer atop [HsYAML](https://hackage.haskell.org/package/HsYAML)
    which allows decoding YAML documents in the more limited JSON data-model while also providing
    convenience by reusing [aeson](https://hackage.haskell.org/package/aeson)'\''s
    '\''FromJSON'\'' instances for decoding the YAML data into native Haskell data types.

category:             Text, Codec, Web, JSON, YAML
abi:                  6f09c1808adb256c6d4c17a9739b8c89
exposed:              True
exposed-modules:      Data.YAML.Aeson
import-dirs:          /usr/lib/ghc-9.2.8/site-local/HsYAML-aeson-0.2.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/HsYAML-aeson-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hsyaml-aeson
hs-libraries:         HSHsYAML-aeson-0.2.0.1-8Oy2FVkLGNvA4GMyoaOsmF
depends:
    HsYAML-0.2.1.3-GNEG2umlvgs1cK3tLrxiA0
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9 base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1 mtl-2.2.2
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI text-1.2.5.0
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN

haddock-interfaces:
    /usr/share/doc/haskell-hsyaml-aeson/html/HsYAML-aeson.haddock

haddock-html:         /usr/share/doc/haskell-hsyaml-aeson/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

