#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hw-fingertree
version:              0.1.2.1
visibility:           public
id:                   hw-fingertree-0.1.2.1-70l6TosEecdLH7oMWIu55G
key:                  hw-fingertree-0.1.2.1-70l6TosEecdLH7oMWIu55G
license:              BSD-3-Clause
copyright:
    (c) 2017-2022 John Ky
    (c) 2006 Ross Paterson, Ralf Hinze,

maintainer:           John Ky <newhoggy@gmail.com>
homepage:             https://github.com/haskell-works/hw-fingertree#readme
synopsis:             Generic finger-tree structure, with example instances
description:
    A general sequence representation with arbitrary
    annotations, for use as a base for implementations of
    various collection types, with examples, as described
    in section 4 of

    * Ralf Hinze and Ross Paterson,
    \"Finger trees: a simple general-purpose data structure\",
    /Journal of Functional Programming/ 16:2 (2006) pp 197-217.
    <http://staff.city.ac.uk/~ross/papers/FingerTree.html>

    For a tuned sequence type, see @Data.Sequence@ in the
    @containers@ package, which is a specialization of
    this structure.

category:             Data Structures
abi:                  012cbb524edc4d7d0fafb73deaa5c0e4
exposed:              True
exposed-modules:
    HaskellWorks.Data.FingerTree
    HaskellWorks.Data.IntervalMap.FingerTree
    HaskellWorks.Data.PriorityQueue.FingerTree

hidden-modules:       Paths_hw_fingertree
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hw-fingertree-0.1.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hw-fingertree-0.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hw-fingertree
hs-libraries:         HShw-fingertree-0.1.2.1-70l6TosEecdLH7oMWIu55G
depends:
    base-4.16.4.0 deepseq-1.4.6.1
    hw-prim-0.6.3.2-6T6ka1CYtJaFbMXfgofVUq

haddock-interfaces:
    /usr/share/doc/haskell-hw-fingertree/html/hw-fingertree.haddock

haddock-html:         /usr/share/doc/haskell-hw-fingertree/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

