#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 quickcheck-instances
version:              0.3.30
visibility:           public
id:                   quickcheck-instances-0.3.30-2a7qY7glJiwHcNHZ19wuny
key:                  quickcheck-instances-0.3.30-2a7qY7glJiwHcNHZ19wuny
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  57546fedf00a6179aacb122b1fca41e8
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.2.8/site-local/quickcheck-instances-0.3.30
library-dirs:         /usr/lib/ghc-9.2.8/site-local/quickcheck-instances-0.3.30
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.30-2a7qY7glJiwHcNHZ19wuny
depends:
    OneTuple-0.4.1.1-Fzf8innqem9KWSxEnQPUoh
    QuickCheck-2.14.3-8QSIOMYs5brCg5V5nmVdY2 array-0.5.4.0
    base-4.16.4.0 bytestring-0.11.4.0
    case-insensitive-1.2.1.0-3YsL0BQanAbLHEhUwcLo8j containers-0.6.5.1
    data-array-byte-0.1.0.1-2qUSeOO400jABsbQDZbSx2
    data-fix-0.3.2-FGkTCFWnE3E5Wykr5tvlhN
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    integer-logarithms-1.0.3.1-6P0sCe8RoauAWF13sn9GHc
    old-time-1.1.0.4-Dlc8YwGlkPi2Y3VNXkrOFg
    primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    splitmix-0.1.0.5-ABz5exdoYzj4Wy0nIHtJet
    strict-0.4.0.1-7vHjqer2uEZJIl7jZqLEWQ
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg text-1.2.5.0
    text-short-0.1.6-1LbBtFl8nZt2KELkxcBYvU
    these-1.1.1.1-1x10Q8jmJcG5CN0o6q3A0h time-1.11.1.1
    time-compat-1.9.6.1-HEeLlSu8aB57PQ9XcXxOia transformers-0.5.6.2
    transformers-compat-0.7.2-9ApmiRwA3hS7UuQpOomcS
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    uuid-types-1.0.5.1-8ydgA9GBSMG7GlP7QxulKE
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

