#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 retrie
version:              1.2.3
visibility:           public
id:                   retrie-1.2.3-Invv04OUSyJK4ie7bbNCtz
key:                  retrie-1.2.3-Invv04OUSyJK4ie7bbNCtz
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  8aae526cb8df974e7fe7e1f4e06df394
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.Elaborate Retrie.ExactPrint Retrie.ExactPrint.Annotated
    Retrie.Expr Retrie.Fixity Retrie.FreeVars Retrie.GHC
    Retrie.GroundTerms Retrie.Monad Retrie.Options
    Retrie.PatternMap.Bag Retrie.PatternMap.Class
    Retrie.PatternMap.Instances Retrie.Pretty Retrie.Quantifiers
    Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.2.8/site-local/retrie-1.2.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/retrie-1.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-retrie
hs-libraries:         HSretrie-1.2.3-Invv04OUSyJK4ie7bbNCtz
depends:
    ansi-terminal-0.11.5-GmxlGl1eC6rGTjWL8Yprft
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS directory-1.3.6.2
    filepath-1.4.2.2 ghc-9.2.8
    ghc-exactprint-1.5.0-8pZfpjxHECU8TxR6uVa9bX
    list-t-1.0.5.5-Eq3ozHcKknJYjGgayKptQ mtl-2.2.2
    optparse-applicative-0.17.1.0-G3d2ugE95DU3DYNCy08LZF
    process-1.6.16.0 random-shuffle-0.0.4-9SjRzqUiLWsCRxDfIUr7sN
    syb-0.7.2.4-89doc1zYrrWCF1u4CgIEo3 text-1.2.5.0
    transformers-0.5.6.2
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

