#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 shake
version:              0.19.6
visibility:           public
id:                   shake-0.19.6-9vhmS3yS10FE4iXSnSgdXD
key:                  shake-0.19.6-9vhmS3yS10FE4iXSnSgdXD
license:              BSD-3-Clause
copyright:            Neil Mitchell 2011-2021
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://shakebuild.com
synopsis:
    Build system library, like Make, but more accurate dependencies.

description:
    Shake is a Haskell library for writing build systems - designed as a
    replacement for @make@. See "Development.Shake" for an introduction,
    including an example. The homepage contains links to a user
    manual, an academic paper and further information:
    <https://shakebuild.com>

    To use Shake the user writes a Haskell program
    that imports "Development.Shake", defines some build rules, and calls
    the '\''Development.Shake.shakeArgs'\'' function. Thanks to do notation and infix
    operators, a simple Shake build system
    is not too dissimilar from a simple Makefile. However, as build systems
    get more complex, Shake is able to take advantage of the excellent
    abstraction facilities offered by Haskell and easily support much larger
    projects. The Shake library provides all the standard features available in other
    build systems, including automatic parallelism and minimal rebuilds.
    Shake also provides more accurate dependency tracking, including seamless
    support for generated files, and dependencies on system information
    (e.g. compiler version).

category:             Development, Shake
abi:                  5a30508d606d6e4407e9963edad29879
exposed:              True
exposed-modules:
    Development.Shake Development.Shake.Classes
    Development.Shake.Command Development.Shake.Config
    Development.Shake.Database Development.Shake.FilePath
    Development.Shake.Forward Development.Shake.Rule
    Development.Shake.Util

hidden-modules:
    Development.Ninja.Env Development.Ninja.Lexer
    Development.Ninja.Parse Development.Ninja.Type
    Development.Shake.Internal.Args
    Development.Shake.Internal.CmdOption
    Development.Shake.Internal.CompactUI
    Development.Shake.Internal.Core.Action
    Development.Shake.Internal.Core.Build
    Development.Shake.Internal.Core.Database
    Development.Shake.Internal.History.Shared
    Development.Shake.Internal.History.Symlink
    Development.Shake.Internal.History.Bloom
    Development.Shake.Internal.History.Cloud
    Development.Shake.Internal.History.Network
    Development.Shake.Internal.History.Server
    Development.Shake.Internal.History.Serialise
    Development.Shake.Internal.History.Types
    Development.Shake.Internal.Core.Monad
    Development.Shake.Internal.Core.Pool
    Development.Shake.Internal.Core.Rules
    Development.Shake.Internal.Core.Run
    Development.Shake.Internal.Core.Storage
    Development.Shake.Internal.Core.Types
    Development.Shake.Internal.Demo Development.Shake.Internal.Derived
    Development.Shake.Internal.Errors
    Development.Shake.Internal.FileInfo
    Development.Shake.Internal.FileName
    Development.Shake.Internal.FilePattern
    Development.Shake.Internal.Options Development.Shake.Internal.Paths
    Development.Shake.Internal.Profile
    Development.Shake.Internal.Progress
    Development.Shake.Internal.Resource
    Development.Shake.Internal.Rules.Default
    Development.Shake.Internal.Rules.Directory
    Development.Shake.Internal.Rules.File
    Development.Shake.Internal.Rules.Files
    Development.Shake.Internal.Rules.Oracle
    Development.Shake.Internal.Rules.OrderOnly
    Development.Shake.Internal.Rules.Rerun
    Development.Shake.Internal.Value General.Bilist General.Binary
    General.Chunks General.Cleanup General.Fence General.EscCodes
    General.Extra General.FileLock General.GetOpt General.Ids
    General.Intern General.ListBuilder General.Makefile General.Pool
    General.Process General.Template General.Thread General.Timing
    General.TypeMap General.Wait Paths_shake

import-dirs:          /usr/lib/ghc-9.2.8/site-local/shake-0.19.6
library-dirs:         /usr/lib/ghc-9.2.8/site-local/shake-0.19.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-shake
hs-libraries:         HSshake-0.19.6-9vhmS3yS10FE4iXSnSgdXD
depends:
    base-4.16.4.0 binary-0.8.9.0 bytestring-0.11.4.0 deepseq-1.4.6.1
    directory-1.3.6.2 extra-1.7.16-HmT1ExbMa8s7Fr43bhn74d
    filepath-1.4.2.2 filepattern-0.1.3-1CNtRSEooNN4BNxv40leCx
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    heaps-0.4-J5nVwdmAeD25PK8wgPMkwt
    js-dgtable-0.5.2-9QcYNIrannTBnclkJddG4d
    js-flot-0.8.3-CzHXKBaovyL8SpvVY5AoqF
    js-jquery-3.3.1-6py3QgpCahT130j0t82iu
    primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl process-1.6.16.0
    random-1.2.1.2-LilJ2o1ueBgJ3oDFJkkk0o time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:   /usr/share/doc/haskell-shake/html/shake.haddock
haddock-html:         /usr/share/doc/haskell-shake/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

