#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 stm-containers
version:              1.2.1
visibility:           public
id:                   stm-containers-1.2.1-BHs89jw9vzgFADhvwaamb6
key:                  stm-containers-1.2.1-BHs89jw9vzgFADhvwaamb6
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.
    .
    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  0107e47e5ce2f7a32d79a7ba0ae80882
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:          /usr/lib/ghc-9.2.8/site-local/stm-containers-1.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/stm-containers-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2.1-BHs89jw9vzgFADhvwaamb6
depends:
    base-4.16.4.0 deferred-folds-0.9.18.6-JF86wGLVb5cGZBMkCI4vPg
    focus-1.0.3.2-6UprU2sPUyeHLEJJj1NaoZ
    hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    list-t-1.0.5.5-Eq3ozHcKknJYjGgayKptQ
    stm-hamt-1.2.1-7wq7XFMc2464z9SymmaJoj transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

