#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tagsoup
version:              0.14.8
visibility:           public
id:                   tagsoup-0.14.8-GPGx2MEbqHMLNyP1JVChHX
key:                  tagsoup-0.14.8-GPGx2MEbqHMLNyP1JVChHX
license:              BSD-3-Clause
copyright:            Neil Mitchell 2006-2019
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/tagsoup#readme
synopsis:
    Parsing and extracting information from (possibly malformed) HTML/XML documents

description:
    TagSoup is a library for parsing HTML/XML. It supports the HTML 5 specification,
    and can be used to parse either well-formed XML, or unstructured and malformed HTML
    from the web. The library also provides useful functions to extract information
    from an HTML document, making it ideal for screen-scraping.

    Users should start from the "Text.HTML.TagSoup" module.

category:             XML
abi:                  9e6a85fe8c78e166c68b3a9f2b324c4d
exposed:              True
exposed-modules:
    Text.HTML.TagSoup Text.HTML.TagSoup.Entity Text.HTML.TagSoup.Match
    Text.HTML.TagSoup.Tree Text.StringLike

hidden-modules:
    Text.HTML.TagSoup.Generated Text.HTML.TagSoup.Implementation
    Text.HTML.TagSoup.Manual Text.HTML.TagSoup.Options
    Text.HTML.TagSoup.Parser Text.HTML.TagSoup.Render
    Text.HTML.TagSoup.Specification Text.HTML.TagSoup.Type

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tagsoup-0.14.8
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tagsoup-0.14.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tagsoup
hs-libraries:         HStagsoup-0.14.8-GPGx2MEbqHMLNyP1JVChHX
depends:
    base-4.16.4.0 bytestring-0.11.4.0 containers-0.6.5.1 text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-tagsoup/html/tagsoup.haddock
haddock-html:         /usr/share/doc/haskell-tagsoup/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

