#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tf-random
version:              0.5
visibility:           public
id:                   tf-random-0.5-IieiBHScofx1RRhO3y60wp
key:                  tf-random-0.5-IieiBHScofx1RRhO3y60wp
license:              BSD-3-Clause
maintainer:           Michał Pałka <michal.palka@chalmers.se>
author:               Michał Pałka <michal.palka@chalmers.se>
synopsis:             High-quality splittable pseudorandom number generator
description:
    This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.

    The package provides the following:

    * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.

    * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.

    * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.

    * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.

    The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.

    Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.

category:             Random
abi:                  30a9c04ff6d967984dc3b5a5b027cc9e
exposed:              True
exposed-modules:
    System.Random.TF System.Random.TF.Gen System.Random.TF.Init
    System.Random.TF.Instances

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tf-random-0.5
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tf-random-0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tf-random
hs-libraries:         HStf-random-0.5-IieiBHScofx1RRhO3y60wp
depends:
    base-4.16.4.0 primitive-0.7.4.0-1hjisjTIkm1Ju7TlHVggBl
    random-1.2.1.2-LilJ2o1ueBgJ3oDFJkkk0o time-1.11.1.1

haddock-interfaces:   /usr/share/doc/haskell-tf-random/html/tf-random.haddock
haddock-html:         /usr/share/doc/haskell-tf-random/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

