#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 th-lift
version:              0.8.4
visibility:           public
id:                   th-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
key:                  th-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
license:              BSD-3-Clause
copyright:
    © 2006 Ian Lynagh, © 2010-2019 Mathieu Boespflug, © 2019 Ryan Scott

maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ian Lynagh
homepage:             http://github.com/RyanGlScott/th-lift
synopsis:             Derive Template Haskell'\''s Lift class for datatypes.
description:
    Derive Template Haskell'\''s @Lift@ class for datatypes using @TemplateHaskell@.
    The functionality in this package has largely been subsumed by the
    @DeriveLift@ language extension, which is available in GHC 8.0 and later
    versions. This package can still be useful as a uniform way to derive
    @Lift@ instances that is backwards-compatible with older GHCs.

    The following libraries are related:

    * The <https://hackage.haskell.org/package/th-orphans th-orphans> package
    provides instances for @template-haskell@ syntax types.

    * The <http://hackage.haskell.org/package/th-lift-instances th-lift-instances>
    package provides @Lift@ instances for types in @base@, @text@,
    @bytestring@, @vector@, etc. Some of these instances are only provided for
    old versions of their respective libraries, as the same @Lift@ instances
    are also present upstream on newer versions.

category:             Language
abi:                  3130ff964a93c23a7ad8b72fc5dea3ad
exposed:              True
exposed-modules:
    Language.Haskell.TH.Lift Language.Haskell.TH.Lift.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/th-lift-0.8.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/th-lift-0.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-th-lift
hs-libraries:         HSth-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
depends:
    base-4.16.4.0 ghc-prim-0.8.0 template-haskell-2.18.0.0
    th-abstraction-0.4.5.0-FQrzhXbdvQX3Z0wTw3euNu

haddock-interfaces:   /usr/share/doc/haskell-th-lift/html/th-lift.haddock
haddock-html:         /usr/share/doc/haskell-th-lift/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

