#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-Ev5wQLTgqalHvZpBHv5Eef
key:                  trifecta-2.1.4-Ev5wQLTgqalHvZpBHv5Eef
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  7779507b54b345f183d17c1901cc1574
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.2.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-Ev5wQLTgqalHvZpBHv5Eef
depends:
    ansi-terminal-0.11.5-GmxlGl1eC6rGTjWL8Yprft array-0.5.4.0
    base-4.16.4.0 blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK
    blaze-html-0.9.2.0-C4ZBPt0ygub3tdDLZwenWL
    blaze-markup-0.8.3.0-F62q6tKjBbGDf7FwMvopea bytestring-0.11.4.0
    charset-0.3.10-5vT6wOBQwqz5SwlVaHhJqI
    comonad-5.0.8-CZGmUOvuZnLIadrIFOwLfh containers-0.6.5.1
    deepseq-1.4.6.1 fingertree-0.1.5.0-BJfLF3cC2IH9TyQaIR6o3F
    ghc-prim-0.8.0 hashable-1.4.4.0-DtL5AH6y1if92iaAq0qoKj
    indexed-traversable-0.1.4-6hGnPWNuqXlFS0NzZXy7sq
    lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7 mtl-2.2.2
    parsers-0.12.11-73EyaS5Do1M6EDsrRiNa8X
    prettyprinter-1.7.1-9qid7zuo3B05OoqIIBWgnL
    prettyprinter-ansi-terminal-1.1.3-LWMhohC2bf65OdaY6HUJHG
    profunctors-5.6.2-INIM7Wdge0m5823pXp4AgG
    reducers-3.12.4-6RWUqutRMToLNUulyfwhyY transformers-0.5.6.2
    unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

