#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 websockets
version:              0.12.7.3
visibility:           public
id:                   websockets-0.12.7.3-1Q3vPH3qZ9aCPAVTGrY3FR
key:                  websockets-0.12.7.3-1Q3vPH3qZ9aCPAVTGrY3FR
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  09dc0ed6347b61ddca728cea5d47e303
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-9.2.8/site-local/websockets-0.12.7.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/websockets-0.12.7.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-websockets
hs-libraries:         HSwebsockets-0.12.7.3-1Q3vPH3qZ9aCPAVTGrY3FR
depends:
    SHA-1.6.4.4-4vZ3YEU9upt6TqgW7hflaa
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv
    attoparsec-0.14.4-IUoeEKVn7Gr6GqDDI9lyTI base-4.16.4.0
    base64-bytestring-1.2.1.0-IROdBrGh8de3SyeGv4rKYj binary-0.8.9.0
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-3YsL0BQanAbLHEhUwcLo8j
    clock-0.8.4-8gAYYIEtjnY1IfqjL0QYZj containers-0.6.5.1
    entropy-0.4.1.10-C5y4ZMubclPFkOssafbGqV
    network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs
    random-1.2.1.2-LilJ2o1ueBgJ3oDFJkkk0o
    streaming-commons-0.2.2.6-HMKHRK40JWKL6Xs9YtqqMP text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

