/* --------------------------------------------------------------------------

   libcoverart - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libcoverart.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libcoverart is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT IT!

----------------------------------------------------------------------------*/


/*
	Things you should delete using the appropriate caa_xxx_delete() function:

	* The coverart object you create to do the actual work
	* The releaseinfo object returned from the caa_coverart_releaseinfo() function
	* Any image data returned from the caa_fetch_xxx functions
	* The return from any caa_xxx_clone() function

	Everything else remains managed by the library, and should not be deleted

	If in doubt, valgrind is a useful way to spot leaks or things being deleted
	when they shouldn't be.

*/

#ifndef _COVERART_MB_C_H
#define _COVERART_MB_C_H

#include "coverart/defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  typedef void *CaaCoverArt;
  typedef void *CaaImage;
  typedef void *CaaReleaseInfo;
  typedef void *CaaThumbnails;
  typedef void *CaaType;
  typedef void *CaaImageList;
  typedef void *CaaTypeList;

/**
* Delete a #CaaCoverArt object
*
* @param CoverArt Object to delete
*/
  void caa_coverart_delete(CaaCoverArt CoverArt);

/**
* Clone a #CaaCoverArt object
*
* @param CoverArt Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  CaaCoverArt caa_coverart_clone(CaaCoverArt CoverArt);

/**
 * @see CoverArtArchive::CCoverArt::LastHTTPCode
 *
 * @param CoverArt #CaaCoverArt object
 *
 * @return Returned value
 */
  int caa_coverart_get_lasthttpcode(CaaCoverArt CoverArt);

/**
 * @see CoverArtArchive::CCoverArt::LastErrorMessage
 *
 * @param CoverArt #CaaCoverArt object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_coverart_get_lasterrormessage(CaaCoverArt CoverArt, char *str, int len);

/**
 * @see CoverArtArchive::CCoverArt::Version
 *
 * @param CoverArt #CaaCoverArt object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_coverart_get_version(CaaCoverArt CoverArt, char *str, int len);

/* --------------------------------------------------------------------------

   libcoverart - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libcoverart.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libcoverart is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

typedef void *CaaImageData;

/**
 * Create a new instance of #CaaCoverArt.
 *
 * @see CoverArtArchive::CCoverArt::CCoverArt
 *
 * @param UserAgent User agent to be passed to submissions
 *
 * @return The newly created #CaaCoverArt object. This object <b>must</b> be deleted once
 *				finished with.
 */

	CaaCoverArt caa_coverart_new(const char *UserAgent);

/**
 * Set the proxy server
 *
 * @see CoverArtArchive::CCoverArt::SetProxyHost
 *
 * @param CoverArt #CaaCoverArt object
 * @param ProxyHost Proxy server to use
 */
	void caa_coverart_set_proxyhost(CaaCoverArt CoverArt, const char *ProxyHost);

/**
 *	Set the port to use on the proxy server
 *
 * @see CoverArtArchive::CCoverArt::SetProxyPort
 *
 * @param CoverArt #CaaCoverArt object
 * @param ProxyPort Port to use on proxy server
 */
	void caa_coverart_set_proxyport(CaaCoverArt CoverArt, int ProxyPort);

/**
 *	Set the username to use to authenticate to the proxy server
 *
 * @see CoverArtArchive::CCoverArt::SetProxyUserName
 *
 * @param CoverArt #CaaCoverArt object
 * @param	ProxyUserName User name to use
 */
	void caa_coverart_set_proxyusername(CaaCoverArt CoverArt, const char *ProxyUserName);

/**
 * Set the password to use to authenticate to the proxy server
 *
 * @see CoverArtArchive::CCoverArt::SetProxyPassword
 *
 * @param CoverArt #CaaCoverArt object
 * @param ProxyPassword Password to use
 */
	void caa_coverart_set_proxypassword(CaaCoverArt CoverArt, const char *ProxyPassword);

/**
 * Request the front image for a release
 *
 * @see CoverArtArchive::CCoverArt::FetchFront
 *
 * @param CoverArt #CaaCoverArt object
 * @param ReleaseID The release ID
 *
 * @return The downloaded image. This object <b>must</b> be deleted once
 *				finished with.
 */
	CaaImageData caa_coverart_fetch_front(CaaCoverArt CoverArt, const char *ReleaseID);

/**
 * Request the back image for a release
 *
 * @see CoverArtArchive::CCoverArt::FetchBack
 *
 * @param CoverArt #CaaCoverArt object
 * @param ReleaseID The release ID
 *
 * @return The downloaded image. This object <b>must</b> be deleted once
 *				finished with.
 */
	CaaImageData caa_coverart_fetch_back(CaaCoverArt CoverArt, const char *ReleaseID);

	typedef enum
	{
		eSize_Full=0,
		eSize_250=250,
		eSize_500=500
	} tImageSize;

/**
 * Request a specific image for a release
 *
 * @see CoverArtArchive::CCoverArt::FetchImage
 *
 * @param CoverArt #CaaCoverArt object
 * @param ReleaseID The release ID
 * @param ImageID The image ID
 * @param ImageSize The size of image to retrieve
 *
 * @return The downloaded image. This object <b>must</b> be deleted once
 *				finished with.
 */
	CaaImageData caa_coverart_fetch_image(CaaCoverArt CoverArt, const char *ReleaseID, const char *ImageID, tImageSize ImageSize);

/**
 * Request all information about a release
 *
 * @see CoverArtArchive::CCoverArt::ReleaseInfo
 *
 * @param CoverArt #CaaCoverArt object
 * @param ReleaseID The release ID
 *
 * @return Release information. This object <b>must</b> be deleted once
 *				finished with.
 */
	CaaReleaseInfo caa_coverart_releaseinfo(CaaCoverArt CoverArt, const char *ReleaseID);

/**
 * @see CoverArtArchive::CCoverArt::tCoverArtResult
 */

	typedef enum
	{
			eCoverArt_Success=0,
			eCoverArt_ConnectionError,
			eCoverArt_Timeout,
			eCoverArt_AuthenticationError,
			eCoverArt_FetchError,
			eCoverArt_RequestError,
			eCoverArt_ResourceNotFound
	} tCoverArtResult;

/**
 * @see CoverArtArchive::CCoverArt::LastResult
 *
 * @param CoverArt #CaaCoverArt object
 *
 * @return Last CoverArt result code
 */
	tCoverArtResult caa_coverart_get_lastresult(CaaCoverArt CoverArt);



/**
* Delete a #CaaImage object
*
* @param Image Object to delete
*/
  void caa_image_delete(CaaImage Image);

/**
* Clone a #CaaImage object
*
* @param Image Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  CaaImage caa_image_clone(CaaImage Image);

/**
 * @see CoverArtArchive::CImage::Approved
 *
 * @param Image #CaaImage object
 *
 * @return Returned value
 */
  int caa_image_get_approved(CaaImage Image);

/**
 * @see CoverArtArchive::CImage::Back
 *
 * @param Image #CaaImage object
 *
 * @return Returned value
 */
  int caa_image_get_back(CaaImage Image);

/**
 * @see CoverArtArchive::CImage::Comment
 *
 * @param Image #CaaImage object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_image_get_comment(CaaImage Image, char *str, int len);

/**
 * @see CoverArtArchive::CImage::Edit
 *
 * @param Image #CaaImage object
 *
 * @return Returned value
 */
  int caa_image_get_edit(CaaImage Image);

/**
 * @see CoverArtArchive::CImage::Front
 *
 * @param Image #CaaImage object
 *
 * @return Returned value
 */
  int caa_image_get_front(CaaImage Image);

/**
 * @see CoverArtArchive::CImage::ID
 *
 * @param Image #CaaImage object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_image_get_id(CaaImage Image, char *str, int len);

/**
 * @see CoverArtArchive::CImage::Image
 *
 * @param Image #CaaImage object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_image_get_image(CaaImage Image, char *str, int len);

/**
 * @see CoverArtArchive::CImage::Thumbnails
 *
 * @param Image #CaaImage object
 *
 * @return #CaaThumbnails object
 */
  CaaThumbnails caa_image_get_thumbnails(CaaImage Image);

/**
 * @see CoverArtArchive::CImage::TypeList
 *
 * @param Image #CaaImage object
 *
 * @return #CaaTypeList object
 */
  CaaTypeList caa_image_get_typelist(CaaImage Image);

/* --------------------------------------------------------------------------

   libcoverart - Client library to access MusicBrainz

   Copyright (C) 2012 Andrew Hawkins

   This file is part of libcoverart.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libcoverart is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
* Delete a #CaaImageData object
*
* @param ImageData Object to delete
*/
  void caa_imagedata_delete(CaaImageData ImageData);

/**
* Clone a #CaaImageData object
*
* @param ImageData Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  CaaImageData caa_imagedata_clone(CaaImageData ImageData);

/**
 * Return the number of bytes in a #CaaImageData object
 *
 * @param ImageData #CaaImageData object
 *
 * @return The number of bytes in the object
 */
	int caa_imagedata_size(CaaImageData ImageData);

/**
 * Return the data in a #CaaImageData object
 *
 * @param ImageData #CaaImageData object
 *
 * @return The data in the object. This data <b>must not</b> be deleted.
 */
	unsigned char *caa_imagedata_data(CaaImageData ImageData);



/**
* Delete a #CaaReleaseInfo object
*
* @param ReleaseInfo Object to delete
*/
  void caa_releaseinfo_delete(CaaReleaseInfo ReleaseInfo);

/**
* Clone a #CaaReleaseInfo object
*
* @param ReleaseInfo Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  CaaReleaseInfo caa_releaseinfo_clone(CaaReleaseInfo ReleaseInfo);

/**
 * @see CoverArtArchive::CReleaseInfo::Release
 *
 * @param ReleaseInfo #CaaReleaseInfo object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_releaseinfo_get_release(CaaReleaseInfo ReleaseInfo, char *str, int len);

/**
 * @see CoverArtArchive::CReleaseInfo::ImageList
 *
 * @param ReleaseInfo #CaaReleaseInfo object
 *
 * @return #CaaImageList object
 */
  CaaImageList caa_releaseinfo_get_imagelist(CaaReleaseInfo ReleaseInfo);

/**
* Delete a #CaaThumbnails object
*
* @param Thumbnails Object to delete
*/
  void caa_thumbnails_delete(CaaThumbnails Thumbnails);

/**
* Clone a #CaaThumbnails object
*
* @param Thumbnails Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  CaaThumbnails caa_thumbnails_clone(CaaThumbnails Thumbnails);

/**
 * @see CoverArtArchive::CThumbnails::Large
 *
 * @param Thumbnails #CaaThumbnails object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_thumbnails_get_large(CaaThumbnails Thumbnails, char *str, int len);

/**
 * @see CoverArtArchive::CThumbnails::Small
 *
 * @param Thumbnails #CaaThumbnails object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_thumbnails_get_small(CaaThumbnails Thumbnails, char *str, int len);

/**
* Delete a #CaaType object
*
* @param Type Object to delete
*/
  void caa_type_delete(CaaType Type);

/**
* Clone a #CaaType object
*
* @param Type Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  CaaType caa_type_clone(CaaType Type);

/**
 * @see CoverArtArchive::CType::Type
 *
 * @param Type #CaaType object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int caa_type_get_type(CaaType Type, char *str, int len);

/**
 * Delete a #CaaImageList
 *
 * @param List List to delete
 */
  void caa_image_list_delete(CaaImageList List);

/**
 * Return the number of entries in a #CaaImageList
 *
 * @param	List List to use
 */
  int caa_image_list_size(CaaImageList List);

/**
 * Returns an entry from a #CaaImageList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #CaaImage object.
 */
  CaaImage caa_image_list_item(CaaImageList List, int Item);

/**
 *	Return the count of entries in an #CaaImageList
 *
 * @param	List List to use
 */
	int caa_image_list_get_count(CaaImageList List);

/**
 *	Return the offset of entries in an #CaaImageList
 *
 * @param	List List to use
 */
	int caa_image_list_get_offset(CaaImageList List);

/**
* Clone an #CaaImageList object
*
* @param ImageList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  CaaImageList caa_image_list_clone(CaaImageList ImageList);

/**
 * Delete a #CaaTypeList
 *
 * @param List List to delete
 */
  void caa_type_list_delete(CaaTypeList List);

/**
 * Return the number of entries in a #CaaTypeList
 *
 * @param	List List to use
 */
  int caa_type_list_size(CaaTypeList List);

/**
 * Returns an entry from a #CaaTypeList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #CaaType object.
 */
  CaaType caa_type_list_item(CaaTypeList List, int Item);

/**
 *	Return the count of entries in an #CaaTypeList
 *
 * @param	List List to use
 */
	int caa_type_list_get_count(CaaTypeList List);

/**
 *	Return the offset of entries in an #CaaTypeList
 *
 * @param	List List to use
 */
	int caa_type_list_get_offset(CaaTypeList List);

/**
* Clone an #CaaTypeList object
*
* @param TypeList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  CaaTypeList caa_type_list_clone(CaaTypeList TypeList);

#ifdef __cplusplus
}
#endif

#endif

