/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.XComponentContext;
import org.openoffice.da.comp.w2lcommon.filter.OptionsDialogBase;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.writer2xhtml.W2XRegistration;

public class XhtmlOptionsDialogCalc
extends OptionsDialogBase {
    public static String __serviceName = "org.openoffice.da.writerxhtml.XhtmlOptionsDialogCalc";
    public static String __implementationName = "org.openoffice.da.comp.writer2xhtml.XhtmlOptionsDialogCalc";

    @Override
    public String getDialogLibraryName() {
        return "W2XDialogs";
    }

    @Override
    public String getDialogName() {
        return "XhtmlOptionsCalc";
    }

    @Override
    public String getRegistryPath() {
        return "/org.openoffice.da.Writer2xhtml.Options/XhtmlOptionsCalc";
    }

    public XhtmlOptionsDialogCalc(XComponentContext xContext) {
        super(xContext);
        this.xMSF = W2XRegistration.xMultiServiceFactory;
    }

    @Override
    protected void loadSettings(XPropertySet xProps) {
        int nColumnScaling;
        this.loadConfig(xProps);
        this.loadCheckBoxOption(xProps, "ConvertToPx");
        int nScaling = this.loadNumericOption(xProps, "Scaling");
        if (nScaling <= 1) {
            this.setNumericFieldValue("Scaling", 100);
        }
        if ((nColumnScaling = this.loadNumericOption(xProps, "ColumnScaling")) <= 1) {
            this.setNumericFieldValue("ColumnScaling", 100);
        }
        this.loadCheckBoxOption(xProps, "OriginalImageSize");
        this.loadCheckBoxOption(xProps, "Notes");
        this.loadCheckBoxOption(xProps, "UseDublinCore");
        this.loadCheckBoxOption(xProps, "DisplayHiddenSheets");
        this.loadCheckBoxOption(xProps, "DisplayHiddenRowsCols");
        this.loadCheckBoxOption(xProps, "DisplayFilteredRowsCols");
        this.loadCheckBoxOption(xProps, "ApplyPrintRanges");
        this.loadCheckBoxOption(xProps, "UseTitleAsHeading");
        this.loadCheckBoxOption(xProps, "UseSheetNamesAsHeadings");
        this.loadCheckBoxOption(xProps, "CalcSplit");
        this.loadCheckBoxOption(xProps, "SaveImagesInSubdir");
        this.updateLockedOptions();
        this.enableControls();
    }

    @Override
    protected void saveSettings(XPropertySet xProps, PropertyHelper helper) {
        short nConfig = this.saveConfig(xProps, helper);
        if (nConfig == 0) {
            helper.put("ConfigURL", "*default.xml");
        } else if (nConfig == 1) {
            helper.put("ConfigURL", "$(user)/writer2xhtml.xml");
            helper.put("AutoCreate", "true");
        }
        this.saveCheckBoxOption(xProps, helper, "ConvertToPx", "convert_to_px");
        this.saveNumericOptionAsPercentage(xProps, helper, "Scaling", "scaling");
        this.saveNumericOptionAsPercentage(xProps, helper, "ColumnScaling", "column_scaling");
        this.saveCheckBoxOption(xProps, "OriginalImageSize");
        helper.put("image_size", this.getCheckBoxStateAsBoolean("OriginalImageSize") ? "none" : "absolute");
        this.saveCheckBoxOption(xProps, helper, "Notes", "notes");
        this.saveCheckBoxOption(xProps, helper, "UseDublinCore", "use_dublin_core");
        this.saveCheckBoxOption(xProps, helper, "DisplayHiddenSheets", "display_hidden_sheets");
        this.saveCheckBoxOption(xProps, helper, "DisplayHiddenRowsCols", "display_hidden_rows_cols");
        this.saveCheckBoxOption(xProps, helper, "DisplayFilteredRowsCols", "display_filtered_rows_cols");
        this.saveCheckBoxOption(xProps, helper, "ApplyPrintRanges", "apply_print_ranges");
        this.saveCheckBoxOption(xProps, helper, "UseTitleAsHeading", "use_title_as_heading");
        this.saveCheckBoxOption(xProps, helper, "UseSheetNamesAsHeadings", "use_sheet_names_as_headings");
        this.saveCheckBoxOption(xProps, helper, "CalcSplit", "calc_split");
        this.saveCheckBoxOption(xProps, helper, "SaveImagesInSubdir", "save_images_in_subdir");
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("ConfigChange")) {
            this.updateLockedOptions();
            this.enableControls();
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"ConfigChange"};
        return sNames;
    }

    private void enableControls() {
        this.setControlEnabled("ConvertToPx", !this.isLocked("convert_to_px"));
        this.setControlEnabled("ScalingLabel", !this.isLocked("scaling"));
        this.setControlEnabled("Scaling", !this.isLocked("scaling"));
        this.setControlEnabled("ColumnScalingLabel", !this.isLocked("column_scaling"));
        this.setControlEnabled("ColumnScaling", !this.isLocked("column_scaling"));
        this.setControlEnabled("OriginalImageSize", !this.isLocked("image_size") && !this.isLocked("original_image_size"));
        this.setControlEnabled("Notes", !this.isLocked("notes"));
        this.setControlEnabled("UseDublinCore", !this.isLocked("use_dublin_core"));
        this.setControlEnabled("DisplayHiddenSheets", !this.isLocked("display_hidden_sheets"));
        this.setControlEnabled("DisplayHiddenRowsCols", !this.isLocked("display_hidden_rows_cols"));
        this.setControlEnabled("DisplayFilteredRowsCols", !this.isLocked("display_filtered_rows_cols"));
        this.setControlEnabled("ApplyPrintRanges", !this.isLocked("apply_print_ranges"));
        this.setControlEnabled("UseTitleAsHeading", !this.isLocked("use_title_as_heading"));
        this.setControlEnabled("UseSheetNamesAsHeadings", !this.isLocked("use_sheet_names_as_headings"));
        this.setControlEnabled("CalcSplit", !this.isLocked("calc_split"));
        this.setControlEnabled("SaveImagesInSubdir", !this.isLocked("save_images_in_subdir"));
    }
}

