/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.routing.Murmur3HashFunction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0003j\u0002`\u000fR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/core/ShardNodes;", "", "localNodeId", "", "activeShardNodeIds", "", "(Ljava/lang/String;Ljava/util/Collection;)V", "circle", "Ljava/util/TreeMap;", "", "getLocalNodeId", "()Ljava/lang/String;", "isOwningNode", "", "id", "Lorg/opensearch/alerting/core/JobId;", "Companion", "alerting-core"})
final class ShardNodes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String localNodeId;
    @NotNull
    private final TreeMap<Integer, String> circle;
    private static final int VIRTUAL_NODE_COUNT = 100;

    public ShardNodes(@NotNull String localNodeId, @NotNull Collection<String> activeShardNodeIds) {
        Intrinsics.checkNotNullParameter((Object)localNodeId, (String)"localNodeId");
        Intrinsics.checkNotNullParameter(activeShardNodeIds, (String)"activeShardNodeIds");
        this.localNodeId = localNodeId;
        this.circle = new TreeMap();
        for (String node : activeShardNodeIds) {
            for (int i = 0; i < 100; ++i) {
                ((Map)this.circle).put(Murmur3HashFunction.hash((String)(node + i)), node);
            }
        }
    }

    @NotNull
    public final String getLocalNodeId() {
        return this.localNodeId;
    }

    public final boolean isOwningNode(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.circle.isEmpty()) {
            return false;
        }
        int hash = Murmur3HashFunction.hash((String)id);
        Map.Entry<Integer, String> entry = this.circle.higherEntry(hash);
        if (entry == null) {
            entry = this.circle.firstEntry();
        }
        String nodeId = entry.getValue();
        return Intrinsics.areEqual((Object)this.localNodeId, (Object)nodeId);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/alerting/core/ShardNodes$Companion;", "", "()V", "VIRTUAL_NODE_COUNT", "", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

