/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.opensearch.core.common.Strings;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.query.rescore.RescoreContext;

public enum CompressionLevel {
    NOT_CONFIGURED(-1, "", null, Collections.emptySet()),
    x1(1, "1x", null, Collections.emptySet()),
    x2(2, "2x", null, Collections.emptySet()),
    x4(4, "4x", null, Collections.emptySet()),
    x8(8, "8x", new RescoreContext(2.0f, false), Set.of(Mode.ON_DISK)),
    x16(16, "16x", new RescoreContext(3.0f, false), Set.of(Mode.ON_DISK)),
    x32(32, "32x", new RescoreContext(3.0f, false), Set.of(Mode.ON_DISK)),
    x64(64, "64x", new RescoreContext(5.0f, false), Set.of(Mode.ON_DISK));

    public static final CompressionLevel MAX_COMPRESSION_LEVEL;
    private static final CompressionLevel DEFAULT;
    private final int compressionLevel;
    private final String name;
    private final RescoreContext defaultRescoreContext;
    private final Set<Mode> modesForRescore;

    public static CompressionLevel fromName(String name) {
        if (Strings.isEmpty((CharSequence)name)) {
            return NOT_CONFIGURED;
        }
        for (CompressionLevel config : CompressionLevel.values()) {
            if (config.getName() == null || !config.getName().equals(name)) continue;
            return config;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid compression level: \"[%s]\"", name));
    }

    public int numBitsForFloat32() {
        if (this == NOT_CONFIGURED) {
            return DEFAULT.numBitsForFloat32();
        }
        return 32 / this.compressionLevel;
    }

    public static boolean isConfigured(CompressionLevel compressionLevel) {
        return compressionLevel != null && compressionLevel != NOT_CONFIGURED;
    }

    public RescoreContext getDefaultRescoreContext(Mode mode, int dimension) {
        if (this.modesForRescore.contains((Object)mode)) {
            if (dimension <= 1000) {
                return RescoreContext.builder().oversampleFactor(5.0f).userProvided(false).build();
            }
            return this.defaultRescoreContext;
        }
        return null;
    }

    @Generated
    private CompressionLevel(int compressionLevel, String name, RescoreContext defaultRescoreContext, Set<Mode> modesForRescore) {
        this.compressionLevel = compressionLevel;
        this.name = name;
        this.defaultRescoreContext = defaultRescoreContext;
        this.modesForRescore = modesForRescore;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        MAX_COMPRESSION_LEVEL = x64;
        DEFAULT = x1;
    }
}

