/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.iterators;

import java.io.IOException;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.iterators.KNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;

public class BinaryVectorIdsKNNIterator
implements KNNIterator {
    protected final BitSetIterator bitSetIterator;
    protected final byte[] queryVector;
    protected final KNNBinaryVectorValues binaryVectorValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public BinaryVectorIdsKNNIterator(@Nullable BitSet filterIdsBitSet, byte[] queryVector, KNNBinaryVectorValues binaryVectorValues, SpaceType spaceType) throws IOException {
        this.bitSetIterator = filterIdsBitSet == null ? null : new BitSetIterator(filterIdsBitSet, (long)filterIdsBitSet.length());
        this.queryVector = queryVector;
        this.binaryVectorValues = binaryVectorValues;
        this.spaceType = spaceType;
        this.docId = this.getNextDocId();
    }

    public BinaryVectorIdsKNNIterator(byte[] queryVector, KNNBinaryVectorValues binaryVectorValues, SpaceType spaceType) throws IOException {
        this(null, queryVector, binaryVectorValues, spaceType);
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = this.computeScore();
        int currentDocId = this.docId;
        this.docId = this.getNextDocId();
        return currentDocId;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        byte[] vector = this.binaryVectorValues.getVector();
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }

    protected int getNextDocId() throws IOException {
        if (this.bitSetIterator == null) {
            return this.binaryVectorValues.nextDoc();
        }
        int nextDocID = this.bitSetIterator.nextDoc();
        if (nextDocID != Integer.MAX_VALUE) {
            this.binaryVectorValues.advance(nextDocID);
        }
        return nextDocID;
    }
}

