/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.iterators;

import java.io.IOException;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.iterators.VectorIdsKNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;

public class NestedVectorIdsKNNIterator
extends VectorIdsKNNIterator {
    private final BitSet parentBitSet;

    public NestedVectorIdsKNNIterator(@Nullable BitSet filterIdsArray, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet) throws IOException {
        this(filterIdsArray, queryVector, knnFloatVectorValues, spaceType, parentBitSet, null, null);
    }

    public NestedVectorIdsKNNIterator(float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet) throws IOException {
        this(null, queryVector, knnFloatVectorValues, spaceType, parentBitSet, null, null);
    }

    public NestedVectorIdsKNNIterator(@Nullable BitSet filterIdsArray, float[] queryVector, KNNFloatVectorValues knnFloatVectorValues, SpaceType spaceType, BitSet parentBitSet, byte[] quantizedVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) throws IOException {
        super(filterIdsArray, queryVector, knnFloatVectorValues, spaceType, quantizedVector, segmentLevelQuantizationInfo);
        this.parentBitSet = parentBitSet;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = Float.NEGATIVE_INFINITY;
        int currentParent = this.parentBitSet.nextSetBit(this.docId);
        int bestChild = -1;
        while (this.docId != Integer.MAX_VALUE && this.docId < currentParent) {
            float score = this.computeScore();
            if (score > this.currentScore) {
                bestChild = this.docId;
                this.currentScore = score;
            }
            this.docId = this.getNextDocId();
        }
        return bestChild;
    }
}

