/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.query.request.MethodParameter;
import org.opensearch.knn.index.util.KNNClusterUtil;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelUtil;
import org.opensearch.knn.jni.JNIService;

public class IndexUtil {
    public static final String MODEL_NODE_ASSIGNMENT_KEY = "training_node_assignment";
    public static final String MODEL_METHOD_COMPONENT_CONTEXT_KEY = "model_definition";
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_LUCENE_HNSW_FILTER = Version.V_2_4_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_IGNORE_UNMAPPED = Version.V_2_11_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MODEL_NODE_ASSIGNMENT = Version.V_2_12_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MODEL_METHOD_COMPONENT_CONTEXT = Version.V_2_13_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_RADIAL_SEARCH = Version.V_2_14_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_METHOD_PARAMETERS = Version.V_2_16_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MODEL_VECTOR_DATA_TYPE = Version.V_2_16_0;
    private static final Version MINIMAL_RESCORE_FEATURE = Version.V_2_17_0;
    private static final Version MINIMAL_MODE_AND_COMPRESSION_FEATURE = Version.V_2_17_0;
    private static final Version MINIMAL_TOP_LEVEL_SPACE_TYPE_FEATURE = Version.V_2_17_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MODEL_VERSION = Version.V_2_17_0;
    public static final Map<String, Version> minimalRequiredVersionMap = IndexUtil.initializeMinimalRequiredVersionMap();
    public static final Set<VectorDataType> VECTOR_DATA_TYPES_NOT_SUPPORTING_ENCODERS = Set.of(VectorDataType.BINARY, VectorDataType.BYTE);

    public static int getFileSizeInKB(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return 0;
        }
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return 0;
        }
        return Math.toIntExact(file.length() / (long)KNNConstants.BYTES_PER_KILOBYTES.intValue() + 1L);
    }

    public static ValidationException validateKnnField(IndexMetadata indexMetadata, String field, int expectedDimension, ModelDao modelDao, VectorDataType trainRequestVectorDataType, KNNMethodContext trainRequestKnnMethodContext) {
        if (indexMetadata == null) {
            throw new IllegalArgumentException("IndexMetadata should not be null");
        }
        ValidationException exception = new ValidationException();
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata == null) {
            exception.addValidationError("Invalid index. Index does not contain a mapping");
            return exception;
        }
        Map properties = (Map)mappingMetadata.getSourceAsMap().get("properties");
        if (properties == null) {
            exception.addValidationError("Properties in map does not exists. This is unexpected");
            return exception;
        }
        if (StringUtils.isEmpty((String)field)) {
            exception.addValidationError(String.format(Locale.ROOT, "Field path is empty.", new Object[0]));
            return exception;
        }
        Object fieldMapping = IndexUtil.getFieldMapping(properties, field);
        if (fieldMapping == null) {
            exception.addValidationError(String.format("Field \"%s\" does not exist.", field));
            return exception;
        }
        if (!(fieldMapping instanceof Map)) {
            exception.addValidationError(String.format("Field info for \"%s\" is not a map.", field));
            return exception;
        }
        Map fieldMap = (Map)fieldMapping;
        Object type = fieldMap.get("type");
        if (!(type instanceof String) || !"knn_vector".equals(type)) {
            exception.addValidationError(String.format("Field \"%s\" is not of type %s.", field, "knn_vector"));
            return exception;
        }
        if (trainRequestVectorDataType != null) {
            MethodComponentContext encoder;
            MethodComponentContext methodComponentContext;
            Map<String, Object> parameters;
            VectorDataType trainIndexDataType = IndexUtil.getVectorDataTypeFromFieldMapping(fieldMap);
            if (trainIndexDataType != trainRequestVectorDataType) {
                exception.addValidationError(String.format(Locale.ROOT, "Field \"%s\" has data type %s, which is different from data type used in the training request: %s", field, trainIndexDataType.getValue(), trainRequestVectorDataType.getValue()));
                return exception;
            }
            if (trainRequestKnnMethodContext != null && (parameters = (methodComponentContext = trainRequestKnnMethodContext.getMethodComponentContext()).getParameters()) != null && parameters.containsKey("encoder") && (encoder = (MethodComponentContext)parameters.get("encoder")) != null && VECTOR_DATA_TYPES_NOT_SUPPORTING_ENCODERS.contains((Object)trainRequestVectorDataType) && !"flat".equals(encoder.getName())) {
                exception.addValidationError(String.format(Locale.ROOT, "encoder is not supported for vector data type [%s]", trainRequestVectorDataType.getValue()));
                return exception;
            }
        }
        if (expectedDimension < 0) {
            return null;
        }
        Object dimension = fieldMap.get("dimension");
        if (dimension == null) {
            String modelId = (String)fieldMap.get("model_id");
            if (modelId == null) {
                exception.addValidationError(String.format("Field \"%s\" does not have a dimension set.", field));
                return exception;
            }
            if (modelDao == null) {
                throw new IllegalArgumentException(String.format("Field \"%s\" uses model. modelDao cannot be null.", field));
            }
            ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
            if (!ModelUtil.isModelCreated(modelMetadata)) {
                exception.addValidationError(String.format("Model \"%s\" for field \"%s\" is not created.", modelId, field));
                return exception;
            }
            dimension = modelMetadata.getDimension();
            if ((Integer)dimension != expectedDimension) {
                exception.addValidationError(String.format("Field \"%s\" has dimension %d, which is different from dimension specified in the training request: %d", field, dimension, expectedDimension));
                return exception;
            }
            return null;
        }
        if ((Integer)dimension != expectedDimension) {
            exception.addValidationError(String.format("Field \"%s\" has dimension %d, which is different from dimension specified in the training request: %d", field, dimension, expectedDimension));
            return exception;
        }
        return null;
    }

    public static Map<String, Object> getParametersAtLoading(SpaceType spaceType, KNNEngine knnEngine, String indexName, VectorDataType vectorDataType) {
        HashMap loadParameters = Maps.newHashMap((Map)ImmutableMap.of((Object)"spaceType", (Object)spaceType.getValue()));
        if (KNNEngine.NMSLIB.equals(knnEngine)) {
            loadParameters.put("efSearch", KNNSettings.getEfSearchParam(indexName));
        }
        loadParameters.put("data_type", vectorDataType.getValue());
        return Collections.unmodifiableMap(loadParameters);
    }

    public static boolean isClusterOnOrAfterMinRequiredVersion(String key) {
        Version minimalRequiredVersion = minimalRequiredVersionMap.get(key);
        if (minimalRequiredVersion == null) {
            return false;
        }
        return KNNClusterUtil.instance().getClusterMinVersion().onOrAfter(minimalRequiredVersion);
    }

    public static boolean isVersionOnOrAfterMinRequiredVersion(Version version, String key) {
        Version minimalRequiredVersion = minimalRequiredVersionMap.get(key);
        if (minimalRequiredVersion == null) {
            return false;
        }
        return version.onOrAfter(minimalRequiredVersion);
    }

    public static boolean isSharedIndexStateRequired(KNNEngine knnEngine, String modelId, long indexAddr) {
        if (StringUtils.isEmpty((String)modelId)) {
            return false;
        }
        return JNIService.isSharedIndexStateRequired(indexAddr, knnEngine);
    }

    public static boolean isBinaryIndex(KNNEngine knnEngine, Map<String, Object> parameters) {
        return KNNEngine.FAISS == knnEngine && parameters.get("data_type") != null && parameters.get("data_type").toString().equals(VectorDataType.BINARY.getValue());
    }

    public static void updateVectorDataTypeToParameters(Map<String, Object> parameters, VectorDataType vectorDataType) {
        if (VectorDataType.BINARY == vectorDataType) {
            parameters.put("data_type", vectorDataType.getValue());
        }
        if (VectorDataType.BYTE == vectorDataType) {
            parameters.put("data_type", vectorDataType.getValue());
        }
    }

    private static Object getFieldMapping(Map<String, Object> properties, String fieldPath) {
        String[] fieldPaths = fieldPath.split("\\.");
        Object currentFieldMapping = properties;
        for (String path : fieldPaths) {
            Object possibleProperties;
            if ((currentFieldMapping = currentFieldMapping.get(path)) == null) {
                return null;
            }
            if (!(currentFieldMapping instanceof Map) || !((possibleProperties = ((Map)currentFieldMapping).get("properties")) instanceof Map)) continue;
            currentFieldMapping = possibleProperties;
        }
        return currentFieldMapping;
    }

    private static VectorDataType getVectorDataTypeFromFieldMapping(Map<String, Object> fieldMap) {
        if (fieldMap.containsKey("data_type")) {
            return VectorDataType.get((String)fieldMap.get("data_type"));
        }
        return VectorDataType.DEFAULT;
    }

    private static Map<String, Version> initializeMinimalRequiredVersionMap() {
        HashMap<String, Version> versionMap = new HashMap<String, Version>(){
            {
                this.put("filter", MINIMAL_SUPPORTED_VERSION_FOR_LUCENE_HNSW_FILTER);
                this.put("ignore_unmapped", MINIMAL_SUPPORTED_VERSION_FOR_IGNORE_UNMAPPED);
                this.put(IndexUtil.MODEL_NODE_ASSIGNMENT_KEY, MINIMAL_SUPPORTED_VERSION_FOR_MODEL_NODE_ASSIGNMENT);
                this.put(IndexUtil.MODEL_METHOD_COMPONENT_CONTEXT_KEY, MINIMAL_SUPPORTED_VERSION_FOR_MODEL_METHOD_COMPONENT_CONTEXT);
                this.put("radial_search", MINIMAL_SUPPORTED_VERSION_FOR_RADIAL_SEARCH);
                this.put("method_parameters", MINIMAL_SUPPORTED_VERSION_FOR_METHOD_PARAMETERS);
                this.put("data_type", MINIMAL_SUPPORTED_VERSION_FOR_MODEL_VECTOR_DATA_TYPE);
                this.put("rescore", MINIMAL_RESCORE_FEATURE);
                this.put("mode_and_compression_feature", MINIMAL_MODE_AND_COMPRESSION_FEATURE);
                this.put("top_level_space_type_feature", MINIMAL_TOP_LEVEL_SPACE_TYPE_FEATURE);
                this.put("model_version", MINIMAL_SUPPORTED_VERSION_FOR_MODEL_VERSION);
            }
        };
        for (MethodParameter methodParameter : MethodParameter.values()) {
            if (methodParameter.getVersion() == null) continue;
            versionMap.put(methodParameter.getName(), methodParameter.getVersion());
        }
        return Collections.unmodifiableMap(versionMap);
    }

    public static boolean isByteIndex(Map<String, Object> parameters) {
        return parameters.getOrDefault("data_type", VectorDataType.DEFAULT.getValue()).toString().equals(VectorDataType.BYTE.getValue());
    }
}

