/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.jni;

import com.sun.jna.Platform;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import oshi.util.platform.mac.SysctlUtil;

public class PlatformUtils {
    private static final Logger logger = LogManager.getLogger(PlatformUtils.class);

    public static boolean isAVX2SupportedBySystem() {
        if (!Platform.isIntel() || Platform.isWindows()) {
            return false;
        }
        if (Platform.isMac()) {
            try {
                return AccessController.doPrivileged(() -> {
                    String flags = SysctlUtil.sysctl((String)"machdep.cpu.leaf7_features", (String)"empty");
                    return flags.toLowerCase(Locale.ROOT).contains("avx2");
                });
            }
            catch (Exception e) {
                logger.error("[KNN] Error fetching cpu flags info. [{}]", (Object)e.getMessage(), (Object)e);
            }
        } else if (Platform.isLinux()) {
            String fileName = "/proc/cpuinfo";
            try {
                return AccessController.doPrivileged(() -> Files.lines(Paths.get(fileName, new String[0])).filter(s -> s.startsWith("flags")).anyMatch(s -> StringUtils.containsIgnoreCase((String)s, (String)"avx2")));
            }
            catch (Exception e) {
                logger.error("[KNN] Error reading file [{}]. [{}]", (Object)fileName, (Object)e.getMessage(), (Object)e);
            }
        }
        return false;
    }

    public static boolean isAVX512SupportedBySystem() {
        if (!Platform.isIntel() || Platform.isMac() || Platform.isWindows()) {
            return false;
        }
        if (Platform.isLinux()) {
            String fileName = "/proc/cpuinfo";
            String[] avx512 = new String[]{"avx512f", "avx512cd", "avx512vl", "avx512dq", "avx512bw"};
            try {
                return AccessController.doPrivileged(() -> {
                    Stream<String> linestream = Files.lines(Paths.get(fileName, new String[0]));
                    String flags = linestream.filter(line -> line.startsWith("flags")).findFirst().orElse("");
                    return Arrays.stream(avx512).allMatch(flags::contains);
                });
            }
            catch (PrivilegedActionException e) {
                logger.error("[KNN] Error reading file [{}]. [{}]", (Object)fileName, (Object)e.getMessage(), (Object)e);
            }
        }
        return false;
    }
}

