/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.rerank;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.neuralsearch.processor.rerank.RerankType;
import org.opensearch.neuralsearch.processor.rerank.RescoringRerankProcessor;
import org.opensearch.neuralsearch.processor.rerank.context.ContextSourceFetcher;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.search.SearchHit;

public class ByFieldRerankProcessor
extends RescoringRerankProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(ByFieldRerankProcessor.class);
    public static final String TARGET_FIELD = "target_field";
    public static final String REMOVE_TARGET_FIELD = "remove_target_field";
    public static final String KEEP_PREVIOUS_SCORE = "keep_previous_score";
    public static final boolean DEFAULT_REMOVE_TARGET_FIELD = false;
    public static final boolean DEFAULT_KEEP_PREVIOUS_SCORE = false;
    protected final String targetField;
    protected final boolean removeTargetField;
    protected final boolean keepPreviousScore;

    public ByFieldRerankProcessor(String description, String tag, boolean ignoreFailure, String targetField, boolean removeTargetField, boolean keepPreviousScore, List<ContextSourceFetcher> contextSourceFetchers) {
        super(RerankType.BY_FIELD, description, tag, ignoreFailure, contextSourceFetchers);
        this.targetField = targetField;
        this.removeTargetField = removeTargetField;
        this.keepPreviousScore = keepPreviousScore;
    }

    @Override
    public void rescoreSearchResponse(SearchResponse response, Map<String, Object> rerankingContext, ActionListener<List<Float>> listener) {
        ProcessorUtils.SearchHitValidator searchHitValidator;
        SearchHit[] searchHits = response.getHits().getHits();
        if (!ProcessorUtils.validateRerankCriteria(searchHits, searchHitValidator = this::byFieldSearchHitValidator, listener)) {
            return;
        }
        ArrayList<Float> scores = new ArrayList<Float>(searchHits.length);
        for (SearchHit hit : searchHits) {
            Map sourceAsMap = hit.getSourceAsMap();
            float score = ProcessorUtils.getScoreFromSourceMap(sourceAsMap, this.targetField);
            scores.add(Float.valueOf(score));
            if (this.keepPreviousScore) {
                sourceAsMap.put("previous_score", Float.valueOf(hit.getScore()));
            }
            if (this.removeTargetField) {
                ProcessorUtils.removeTargetFieldFromSource(sourceAsMap, this.targetField);
            }
            try {
                XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());
                BytesReference sourceMapAsBytes = BytesReference.bytes((XContentBuilder)builder.map(sourceAsMap));
                hit.sourceRef(sourceMapAsBytes);
            }
            catch (IOException e) {
                log.error(e.getMessage());
                listener.onFailure((Exception)new RuntimeException(e));
                return;
            }
        }
        listener.onResponse(scores);
    }

    public void byFieldSearchHitValidator(SearchHit hit) {
        if (!hit.hasSource()) {
            log.error(String.format(Locale.ROOT, "There is no source field to be able to perform rerank on hit [%d]", hit.docId()));
            throw new IllegalArgumentException(String.format(Locale.ROOT, "There is no source field to be able to perform rerank on hit [%d]", hit.docId()));
        }
        Map sourceMap = hit.getSourceAsMap();
        if (!ProcessorUtils.mappingExistsInSource(sourceMap, this.targetField)) {
            log.error(String.format(Locale.ROOT, "The field to rerank [%s] is not found at hit [%d]", this.targetField, hit.docId()));
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field to rerank by is not found at hit [%d]", hit.docId()));
        }
        Optional<Object> val = ProcessorUtils.getValueFromSource(sourceMap, this.targetField);
        if (!(val.get() instanceof Number)) {
            log.error(String.format(Locale.ROOT, "The field mapping to rerank [%s: %s] is not Numerical", this.targetField, val.orElse(null)));
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field mapping to rerank by [%s] is not Numerical", val.orElse(null)));
        }
    }
}

