/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.neuralsearch.search.query.HybridAggregationProcessor;
import org.opensearch.neuralsearch.util.HybridQueryUtil;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.ConcurrentQueryPhaseSearcher;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.QueryPhase;
import org.opensearch.search.query.QueryPhaseSearcher;
import org.opensearch.search.query.QueryPhaseSearcherWrapper;

public class HybridQueryPhaseSearcher
extends QueryPhaseSearcherWrapper {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridQueryPhaseSearcher.class);
    private final QueryPhaseSearcher defaultQueryPhaseSearcherWithEmptyCollectorContext = new DefaultQueryPhaseSearcherWithEmptyQueryCollectorContext();
    private final QueryPhaseSearcher concurrentQueryPhaseSearcherWithEmptyCollectorContext = new ConcurrentQueryPhaseSearcherWithEmptyQueryCollectorContext();

    public boolean searchWith(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
        if (!HybridQueryUtil.isHybridQuery(query, searchContext)) {
            this.validateQuery(searchContext, query);
            return super.searchWith(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
        }
        if (searchContext.from() != 0) {
            throw new IllegalArgumentException("In the current OpenSearch version pagination is not supported with hybrid query");
        }
        Query hybridQuery = this.extractHybridQuery(searchContext, query);
        QueryPhaseSearcher queryPhaseSearcher = this.getQueryPhaseSearcher(searchContext);
        queryPhaseSearcher.searchWith(searchContext, searcher, hybridQuery, collectors, hasFilterCollector, hasTimeout);
        return false;
    }

    private QueryPhaseSearcher getQueryPhaseSearcher(SearchContext searchContext) {
        return searchContext.shouldUseConcurrentSearch() ? this.concurrentQueryPhaseSearcherWithEmptyCollectorContext : this.defaultQueryPhaseSearcherWithEmptyCollectorContext;
    }

    private static boolean isWrappedHybridQuery(Query query) {
        return query instanceof BooleanQuery && ((BooleanQuery)query).clauses().stream().anyMatch(clauseQuery -> clauseQuery.getQuery() instanceof HybridQuery);
    }

    @VisibleForTesting
    protected Query extractHybridQuery(SearchContext searchContext, Query query) {
        if ((HybridQueryUtil.hasAliasFilter(query, searchContext) || HybridQueryUtil.hasNestedFieldOrNestedDocs(query, searchContext)) && HybridQueryPhaseSearcher.isWrappedHybridQuery(query) && !((BooleanQuery)query).clauses().isEmpty()) {
            List booleanClauses = ((BooleanQuery)query).clauses();
            if (!(((BooleanClause)booleanClauses.get(0)).getQuery() instanceof HybridQuery)) {
                throw new IllegalStateException("cannot process hybrid query due to incorrect structure of top level query");
            }
            HybridQuery hybridQuery = (HybridQuery)((BooleanClause)booleanClauses.stream().findFirst().get()).getQuery();
            List<Query> filterQueries = booleanClauses.stream().filter(clause -> BooleanClause.Occur.FILTER == clause.getOccur()).map(BooleanClause::getQuery).collect(Collectors.toList());
            HybridQuery hybridQueryWithFilter = new HybridQuery(hybridQuery.getSubQueries(), filterQueries);
            return hybridQueryWithFilter;
        }
        return query;
    }

    private void validateQuery(SearchContext searchContext, Query query) {
        if (query instanceof BooleanQuery) {
            List booleanClauses = ((BooleanQuery)query).clauses();
            for (BooleanClause booleanClause : booleanClauses) {
                this.validateNestedBooleanQuery(booleanClause.getQuery(), this.getMaxDepthLimit(searchContext));
            }
        }
    }

    private void validateNestedBooleanQuery(Query query, int level) {
        if (query instanceof HybridQuery) {
            throw new IllegalArgumentException("hybrid query must be a top level query and cannot be wrapped into other queries");
        }
        if (level <= 0) {
            log.error("reached max nested query limit, cannot process bool query with that many nested clauses");
            return;
        }
        if (query instanceof BooleanQuery) {
            for (BooleanClause booleanClause : ((BooleanQuery)query).clauses()) {
                this.validateNestedBooleanQuery(booleanClause.getQuery(), level - 1);
            }
        }
    }

    private int getMaxDepthLimit(SearchContext searchContext) {
        Settings indexSettings = searchContext.getQueryShardContext().getIndexSettings().getSettings();
        return ((Long)MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING.get(indexSettings)).intValue();
    }

    public AggregationProcessor aggregationProcessor(SearchContext searchContext) {
        AggregationProcessor coreAggProcessor = super.aggregationProcessor(searchContext);
        return new HybridAggregationProcessor(coreAggProcessor);
    }

    final class DefaultQueryPhaseSearcherWithEmptyQueryCollectorContext
    extends QueryPhase.DefaultQueryPhaseSearcher {
        protected boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
            return this.searchWithCollector(searchContext, searcher, query, collectors, QueryCollectorContext.EMPTY_CONTEXT, hasFilterCollector, hasTimeout);
        }

        @Generated
        DefaultQueryPhaseSearcherWithEmptyQueryCollectorContext() {
        }
    }

    final class ConcurrentQueryPhaseSearcherWithEmptyQueryCollectorContext
    extends ConcurrentQueryPhaseSearcher {
        protected boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
            return this.searchWithCollector(searchContext, searcher, query, collectors, QueryCollectorContext.EMPTY_CONTEXT, hasFilterCollector, hasTimeout);
        }

        @Generated
        private ConcurrentQueryPhaseSearcherWithEmptyQueryCollectorContext() {
        }
    }
}

