#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-2HRJ4jB1X3DLxu7qAIPMG1
key:                  postgrest-10.0.0-2HRJ4jB1X3DLxu7qAIPMG1
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  3e2684b7ebfb8b4c5f981c371c9a5548
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.2.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-2HRJ4jB1X3DLxu7qAIPMG1
depends:
    HTTP-4000.4.1-5nFEM9UriQzLKvlYKISiN1
    Ranged-sets-0.4.0-2W7USErHMOmv8VPyciMeD
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    auto-update-0.1.6-2uGvl5U8HrOKlypXpY3P5F base-4.16.4.0
    base64-bytestring-1.2.1.0-IROdBrGh8de3SyeGv4rKYj
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-3YsL0BQanAbLHEhUwcLo8j
    cassava-0.5.3.2-KYxSsEiPscTI84btZ9NDhj
    configurator-pg-0.2.9-7i32Qo7ZoaEFe8xVPIaJsI containers-0.6.5.1
    contravariant-extras-0.3.5.4-KQODmY3btn6QQJWMypRoY
    cookie-0.4.6-ATAyIjNvKdDFVIoN0dB8l5 directory-1.3.6.2
    either-5.0.2-AtRiUEGr5OmtFhB2bWxlv
    gitrev-1.3.1-9lQGgHpaqCODNpyMdeEqev
    hasql-1.5.0.4-2DhHt4WvbHy16DawMIWWlL
    hasql-dynamic-statements-0.3.1.1-HIn9RLGMnzG9BfrDsYvUHJ
    hasql-notifications-0.2.0.4-963Iim4wQJlH9emZVAbGWX
    hasql-pool-0.5.2.2-4DHD5kdeZYCHeQBG2bzGZZ
    hasql-transaction-1.0.1.1-GWzCcfpHkTz5OO9cX6QrIC
    heredoc-0.2.0.0-D3AW9S2AOKs91e3wqBbhAD
    http-types-0.12.4-6kOruwBLItLEcotK7uAwKL
    insert-ordered-containers-0.2.5.3-FEXQ7dhVG4DHjDSbEeT75P
    interpolatedstring-perl6-1.0.2-Aks2klYx7Q0CqSAmNtVrsT
    jose-0.10-BMnuJEdLLJ07rrRnDZXEQS lens-5.2.3-QYXO5VAAmZ55WrLxxHJc7
    lens-aeson-1.2.3-Ch6mEKsVkOD3BIKGZvysVv mtl-2.2.2
    network-3.1.4.0-1av7pSyu1s1AG52DPIhcGs
    network-uri-2.6.4.2-74JpbzeSIdyJoqu3FQVNpR
    optparse-applicative-0.17.1.0-G3d2ugE95DU3DYNCy08LZF
    parsec-3.1.15.0 protolude-0.3.4-3n6Q68aKrxW7jfDHvPy08L
    regex-tdfa-1.3.2.2-743XGAHrGLPIAyhrr2nNbU
    retry-0.9.3.1-6nrvrNbdH6K5G0oW9L8Yzd
    scientific-0.3.7.0-8ausramh0PCAAyDmAQtWkI
    swagger2-2.8.9-4BZ1NIfDKN1H715pGxKneu text-1.2.5.0 time-1.11.1.1
    unix-2.7.2.2 unordered-containers-0.2.20-KbuohGKDXjMH23185MHhrF
    vault-0.3.1.5-4WbcwM4j7H64NFS3MixAuB
    vector-0.13.1.0-1Hbj4hORR7KGMeSpv0BhQN
    wai-3.2.4-4FGE67nPXB9CBfEQ1pErUn
    wai-cors-0.2.7-1UqjOTtIEcf83shFLWCNbq
    wai-extra-3.1.15-IfXehs5zzXT5ANQAlnJqyx
    wai-logger-2.5.0-Agk9dhlcc0YKyScClmg4MR
    warp-3.3.30-2sfgu9L9nPVIzEg502tKwp

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

