/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.sdedit.util.DOMNode;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.DocumentTree;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Utilities;
import net.sf.sdedit.util.tree.Traversal;
import net.sf.sdedit.util.tree.TraversalControl;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DOMNodeAdapter
implements DOMNode,
TraversalControl<Node> {
    private static XPathFactory xPathFactory = XPathFactory.newInstance();
    private static WeakHashMap<Node, DOMNode> nodeMap = new WeakHashMap();
    private final Node node;
    private List<Pair<Integer, Node>> descendants;
    private Map<String, Object> userObjects;

    static DOMNode makeNode(Node node) {
        DOMNode dnode = nodeMap.get(node);
        if (dnode != null) {
            return dnode;
        }
        dnode = new DOMNodeAdapter(node);
        nodeMap.put(node, dnode);
        return dnode;
    }

    private DOMNodeAdapter(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.node = node;
    }

    @Override
    public String getAttribute(String name) {
        if (!(this.node instanceof Element)) {
            return null;
        }
        return DocUtil.getAttribute((Element)this.node, name);
    }

    @Override
    public void setAttribute(String name, String value) {
        NamedNodeMap nnm = this.node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            if (!nnm.item(i).getNodeName().equalsIgnoreCase(name)) continue;
            nnm.item(i).setNodeValue(value);
            return;
        }
        this.addAttribute(name, value);
    }

    private void addAttribute(String name, String value) {
        ((Element)this.node).setAttribute(name, value);
    }

    @Override
    public List<String> getAttributeNames() {
        LinkedList<String> result = new LinkedList<String>();
        NamedNodeMap nnm = this.node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            result.add(nnm.item(i).getNodeName());
        }
        return result;
    }

    @Override
    public DOMNode findNode(String exp) {
        XPath xpath = xPathFactory.newXPath();
        try {
            Node result = (Node)xpath.evaluate(exp, this.node, XPathConstants.NODE);
            if (result == null) {
                return null;
            }
            return DOMNodeAdapter.makeNode(result);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public List<DOMNode> findNodes(String exp) {
        XPath xpath = xPathFactory.newXPath();
        LinkedList<DOMNode> result = new LinkedList<DOMNode>();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(exp, this.node, XPathConstants.NODESET);
            for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
                result.add(DOMNodeAdapter.makeNode(nodes.item(i)));
            }
            return result;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return DocUtil.toString(this.node);
    }

    @Override
    public int getLevel() {
        int level = 0;
        for (Node n = this.node; n != this.node.getOwnerDocument().getDocumentElement(); n = n.getParentNode()) {
            ++level;
        }
        return level;
    }

    private void computeDescendants() {
        DocumentTree<Node> tree = new DocumentTree<Node>(this.node, Node.class);
        Traversal<Node> traversal = new Traversal<Node>(this);
        this.descendants = new LinkedList<Pair<Integer, Node>>();
        traversal.traverse(tree);
    }

    @Override
    public <T extends Node> DOMNode getPreviousSibling(Class<T> nodeClass) {
        Node n = this.node;
        while (n != null) {
            if (!nodeClass.isInstance(n = n.getPreviousSibling())) continue;
            return DOMNodeAdapter.makeNode(n);
        }
        return null;
    }

    @Override
    public <T extends Node> DOMNode getNextSibling(Class<T> nodeClass) {
        Node n = this.node;
        while (n != null) {
            if (!nodeClass.isInstance(n = n.getNextSibling())) continue;
            return DOMNodeAdapter.makeNode(n);
        }
        return null;
    }

    @Override
    public List<DOMNode> getDescendantsDFS() {
        this.computeDescendants();
        LinkedList<DOMNode> result = new LinkedList<DOMNode>();
        for (Pair<Integer, Node> pair : this.descendants) {
            result.add(DOMNodeAdapter.makeNode(pair.getSecond()));
        }
        return result;
    }

    @Override
    public String toTreeString() {
        this.computeDescendants();
        PrintWriter pw = Utilities.createPrintWriter();
        for (Pair<Integer, Node> pair : this.descendants) {
            pw.println(Utilities.pad(' ', 2 * pair.getFirst()) + DocUtil.toString(pair.getSecond()));
        }
        return Utilities.toString(pw);
    }

    @Override
    public List<DOMNode> getChildren() {
        LinkedList<DOMNode> list = new LinkedList<DOMNode>();
        for (Node n : DocUtil.iterate(this.node.getChildNodes())) {
            list.add(DOMNodeAdapter.makeNode(n));
        }
        return list;
    }

    @Override
    public List<DOMNode> getChildren(String name) {
        LinkedList<DOMNode> list = new LinkedList<DOMNode>();
        for (Node n : DocUtil.iterate(this.node.getChildNodes())) {
            if (!name.equals(n.getNodeName())) continue;
            list.add(DOMNodeAdapter.makeNode(n));
        }
        return list;
    }

    @Override
    public DOMNode getParent() {
        if (this.node == this.node.getOwnerDocument().getDocumentElement()) {
            return null;
        }
        return DOMNodeAdapter.makeNode(this.node.getParentNode());
    }

    @Override
    public String getText() {
        return this.node.getTextContent();
    }

    @Override
    public DOMNode getChild(String name) {
        List<DOMNode> children = this.getChildren(name);
        if (children.size() == 0) {
            return null;
        }
        return children.get(0);
    }

    @Override
    public String getName() {
        return this.node.getNodeName();
    }

    @Override
    public void beginTraversal(Node t, int level) {
        this.descendants.add(new Pair<Integer, Node>(level, t));
    }

    @Override
    public boolean doTraverse(Node t, int level) {
        return true;
    }

    @Override
    public void endTraversal(Node t, boolean leaf) {
    }

    @Override
    public boolean isLeaf() {
        return this.node.getChildNodes().getLength() == 0;
    }

    @Override
    public Object getUserObject(String name) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(name);
    }

    @Override
    public void setUserObject(String name, Object object) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<String, Object>();
        }
        this.userObjects.put(name, object);
    }

    @Override
    public <T extends Node> List<DOMNode> getChildren(Class<T> nodeClass) {
        LinkedList<DOMNode> result = new LinkedList<DOMNode>();
        for (DOMNodeAdapter child : Utilities.castIterable(this.getChildren(), DOMNodeAdapter.class)) {
            if (!nodeClass.isInstance(child.node)) continue;
            result.add(child);
        }
        return result;
    }
}

