import { WritableDocument } from './DocumentBase';
import { TagInformation } from './utils';
import { SvelteConfig } from './configLoader';
import { HTMLDocument } from 'vscode-html-languageservice';
import { Range } from 'vscode-languageserver';
/**
 * Represents a text document contains a svelte component.
 */
export declare class Document extends WritableDocument {
    url: string;
    content: string;
    languageId: string;
    scriptInfo: TagInformation | null;
    moduleScriptInfo: TagInformation | null;
    styleInfo: TagInformation | null;
    templateInfo: TagInformation | null;
    configPromise: Promise<SvelteConfig | undefined>;
    config?: SvelteConfig;
    html: HTMLDocument;
    openedByClient: boolean;
    /**
     * Compute and cache directly because of performance reasons
     * and it will be called anyway.
     */
    private path;
    constructor(url: string, content: string);
    private updateDocInfo;
    /**
     * Get text content
     */
    getText(range?: Range): string;
    /**
     * Set text content and increase the document version
     */
    setText(text: string): void;
    /**
     * Returns the file path if the url scheme is file
     */
    getFilePath(): string | null;
    /**
     * Get URL file path.
     */
    getURL(): string;
    /**
     * Returns the language associated to script, style or template.
     * Returns an empty string if there's nothing set.
     */
    getLanguageAttribute(tag: 'script' | 'style' | 'template'): string;
    /**
     * Returns true if there's `lang="X"` on script or style or template.
     */
    hasLanguageAttribute(): boolean;
    /**
     * @deprecated This no longer exists in svelte-preprocess v5, we leave it in in case someone is using this with v4
     */
    private addDefaultLanguage;
}
