import { CompletionList, Hover, Position, SymbolInformation, Range, WorkspaceEdit, LinkedEditingRanges, CompletionContext, FoldingRange } from 'vscode-languageserver';
import { DocumentManager, Document } from '../../lib/documents';
import { LSConfigManager } from '../../ls-config';
import { HoverProvider, CompletionsProvider, RenameProvider, LinkedEditingRangesProvider, FoldingRangeProvider } from '../interfaces';
export declare class HTMLPlugin implements HoverProvider, CompletionsProvider, RenameProvider, LinkedEditingRangesProvider, FoldingRangeProvider {
    private configManager;
    __name: string;
    private lang;
    private documents;
    private styleScriptTemplate;
    private htmlTriggerCharacters;
    constructor(docManager: DocumentManager, configManager: LSConfigManager);
    doHover(document: Document, position: Position): Hover | null;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext): Promise<CompletionList | null>;
    /**
     * The HTML language service uses newer types which clash
     * without the stable ones. Transform to the stable types.
     */
    private toCompletionItems;
    private isInComponentTag;
    private getLangCompletions;
    doTagComplete(document: Document, position: Position): string | null;
    private isInsideMoustacheTag;
    getDocumentSymbols(document: Document): SymbolInformation[];
    rename(document: Document, position: Position, newName: string): WorkspaceEdit | null;
    prepareRename(document: Document, position: Position): Range | null;
    getLinkedEditingRanges(document: Document, position: Position): LinkedEditingRanges | null;
    getFoldingRanges(document: Document): FoldingRange[];
    /**
     * Returns true if rename happens at the tag name, not anywhere inbetween.
     */
    private isRenameAtTag;
    private getCustomDataProviders;
    private featureEnabled;
}
