"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const path = __importStar(require("path"));
const typescript_1 = __importDefault(require("typescript"));
const documents_1 = require("../../../../src/lib/documents");
const ls_config_1 = require("../../../../src/ls-config");
const LSAndTSDocResolver_1 = require("../../../../src/plugins/typescript/LSAndTSDocResolver");
const CodeLensProvider_1 = require("../../../../src/plugins/typescript/features/CodeLensProvider");
const FindComponentReferencesProvider_1 = require("../../../../src/plugins/typescript/features/FindComponentReferencesProvider");
const FindReferencesProvider_1 = require("../../../../src/plugins/typescript/features/FindReferencesProvider");
const ImplementationProvider_1 = require("../../../../src/plugins/typescript/features/ImplementationProvider");
const utils_1 = require("../../../../src/utils");
const test_utils_1 = require("../test-utils");
const testDir = path.join(__dirname, '..');
describe('CodeLensProvider', function () {
    (0, test_utils_1.serviceWarmup)(this, path.join(testDir, 'testfiles', 'codelens'), (0, utils_1.pathToUrl)(testDir));
    function getFullPath(filename) {
        return path.join(testDir, 'testfiles', 'codelens', filename);
    }
    function getUri(filename) {
        return (0, utils_1.pathToUrl)(getFullPath(filename));
    }
    function setup(filename) {
        const docManager = new documents_1.DocumentManager((textDocument) => new documents_1.Document(textDocument.uri, textDocument.text));
        const lsConfigManager = new ls_config_1.LSConfigManager();
        const lsAndTsDocResolver = new LSAndTSDocResolver_1.LSAndTSDocResolver(docManager, [(0, utils_1.pathToUrl)(testDir)], lsConfigManager);
        const componentReferencesProvider = new FindComponentReferencesProvider_1.FindComponentReferencesProviderImpl(lsAndTsDocResolver);
        const referenceProvider = new FindReferencesProvider_1.FindReferencesProviderImpl(lsAndTsDocResolver, componentReferencesProvider);
        const implementationProvider = new ImplementationProvider_1.ImplementationProviderImpl(lsAndTsDocResolver);
        const provider = new CodeLensProvider_1.CodeLensProviderImpl(lsAndTsDocResolver, referenceProvider, implementationProvider, lsConfigManager);
        const filePath = getFullPath(filename);
        const document = docManager.openClientDocument({
            uri: (0, utils_1.pathToUrl)(filePath),
            text: typescript_1.default.sys.readFile(filePath) || ''
        });
        return { provider, document, lsConfigManager };
    }
    it('provides reference codelens', async () => {
        const { provider, document, lsConfigManager } = setup('references.svelte');
        lsConfigManager.updateTsJsUserPreferences({
            typescript: { referencesCodeLens: { enabled: true } },
            javascript: {}
        });
        const codeLenses = await provider.getCodeLens(document);
        const references = codeLenses?.filter((lens) => lens.data.type === 'reference');
        assert.deepStrictEqual(references, [
            {
                range: {
                    start: { line: 0, character: 0 },
                    end: { line: 0, character: 1 }
                },
                data: { type: 'reference', uri: getUri('references.svelte') }
            },
            {
                range: {
                    start: { line: 1, character: 14 },
                    end: { line: 1, character: 17 }
                },
                data: { type: 'reference', uri: getUri('references.svelte') }
            },
            {
                range: {
                    start: { line: 2, character: 8 },
                    end: { line: 2, character: 11 }
                },
                data: { type: 'reference', uri: getUri('references.svelte') }
            }
        ]);
    });
    it('resolve reference codelens', async () => {
        const { provider, document } = setup('references.svelte');
        const codeLens = await provider.resolveCodeLens(document, {
            range: {
                start: { line: 1, character: 14 },
                end: { line: 1, character: 17 }
            },
            data: { type: 'reference', uri: getUri('references.svelte') }
        });
        assert.deepStrictEqual(codeLens.command, {
            title: '1 reference',
            command: '',
            arguments: [
                getUri('references.svelte'),
                { line: 1, character: 14 },
                [
                    {
                        uri: getUri('references.svelte'),
                        range: {
                            start: { line: 5, character: 13 },
                            end: { line: 5, character: 16 }
                        }
                    }
                ]
            ]
        });
    });
    it('resolve component reference codelens', async () => {
        const { provider, document } = setup('references.svelte');
        const codeLens = await provider.resolveCodeLens(document, {
            range: {
                start: { line: 0, character: 0 },
                end: { line: 0, character: 1 }
            },
            data: { type: 'reference', uri: getUri('references.svelte') }
        });
        assert.deepStrictEqual(codeLens.command, {
            title: '2 references',
            command: '',
            arguments: [
                getUri('references.svelte'),
                { line: 0, character: 0 },
                [
                    {
                        uri: getUri('importing.svelte'),
                        range: {
                            start: { line: 1, character: 11 },
                            end: { line: 1, character: 21 }
                        }
                    },
                    {
                        uri: getUri('importing.svelte'),
                        range: { start: { line: 4, character: 1 }, end: { line: 4, character: 11 } }
                    }
                ]
            ]
        });
    });
    it('provides implementation codelens', async () => {
        const { provider, document, lsConfigManager } = setup('references.svelte');
        lsConfigManager.updateTsJsUserPreferences({
            typescript: { implementationsCodeLens: { enabled: true } },
            javascript: {}
        });
        const codeLenses = await provider.getCodeLens(document);
        const references = codeLenses?.filter((lens) => lens.data.type === 'implementation');
        assert.deepStrictEqual(references, [
            {
                range: {
                    start: { line: 1, character: 14 },
                    end: { line: 1, character: 17 }
                },
                data: { type: 'implementation', uri: getUri('references.svelte') }
            }
        ]);
    });
    it('resolve implementation codelens', async () => {
        const { provider, document } = setup('references.svelte');
        const codeLens = await provider.resolveCodeLens(document, {
            range: {
                start: { line: 1, character: 14 },
                end: { line: 1, character: 17 }
            },
            data: { type: 'implementation', uri: getUri('references.svelte') }
        });
        assert.deepStrictEqual(codeLens.command, {
            title: '1 implementation',
            command: '',
            arguments: [
                getUri('references.svelte'),
                { line: 1, character: 14 },
                [
                    {
                        uri: getUri('references.svelte'),
                        range: {
                            start: { line: 5, character: 19 },
                            end: { line: 5, character: 33 }
                        }
                    }
                ]
            ]
        });
    });
});
//# sourceMappingURL=CodeLensProvider.test.js.map