#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 xmobar
version:              0.48.1
visibility:           public
id:                   xmobar-0.48.1-3I4VXAwIEwy8YBtTtFl6of
key:                  xmobar-0.48.1-3I4VXAwIEwy8YBtTtFl6of
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             https://codeberg.org/xmobar/xmobar
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  4c83a77aa77ae49223294bff49c81a18
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Config.Template Xmobar.Run.Types Xmobar.Run.Timer
    Xmobar.Run.Template Xmobar.Run.Exec Xmobar.Run.Runnable
    Xmobar.Run.Actions Xmobar.Run.Loop Xmobar.Draw.Boxes
    Xmobar.Draw.Cairo Xmobar.Draw.Types Xmobar.App.Config
    Xmobar.App.Main Xmobar.App.Opts Xmobar.App.Compile
    Xmobar.System.Utils Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.Text.Ansi Xmobar.Text.Loop Xmobar.Text.Pango
    Xmobar.Text.Swaybar Xmobar.Text.SwaybarClicks Xmobar.Text.Output
    Xmobar.X11.Bitmap Xmobar.X11.CairoSurface Xmobar.X11.ColorCache
    Xmobar.X11.Draw Xmobar.X11.Events Xmobar.X11.Loop Xmobar.X11.Text
    Xmobar.X11.Types Xmobar.X11.Window Xmobar.Plugins.Command
    Xmobar.Plugins.BufferedPipeReader Xmobar.Plugins.CommandReader
    Xmobar.Plugins.Date Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.QueueReader Xmobar.Plugins.PipeReader
    Xmobar.Plugins.MarqueePipeReader Xmobar.Plugins.StdinReader
    Xmobar.Plugins.XMonadLog Xmobar.Plugins.Kbd Xmobar.Plugins.Locks
    Xmobar.Plugins.NotmuchMail Xmobar.Plugins.Monitors
    Xmobar.Plugins.Monitors.Batt Xmobar.Plugins.Monitors.Batt.Common
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.K10Temp
    Xmobar.Plugins.Monitors.Cpu.Common Xmobar.Plugins.Monitors.CpuFreq
    Xmobar.Plugins.Monitors.Disk Xmobar.Plugins.Monitors.Disk.Common
    Xmobar.Plugins.Monitors.Load Xmobar.Plugins.Monitors.Load.Common
    Xmobar.Plugins.Monitors.Mem Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Net.Common Xmobar.Plugins.Monitors.Swap
    Xmobar.Plugins.Monitors.Thermal Xmobar.Plugins.Monitors.ThermalZone
    Xmobar.Plugins.Monitors.Top Xmobar.Plugins.Monitors.Top.Common
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.XRender
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather Xmobar.Plugins.Monitors.Batt.Linux
    Xmobar.Plugins.Monitors.Cpu.Linux
    Xmobar.Plugins.Monitors.Disk.Linux
    Xmobar.Plugins.Monitors.Load.Linux
    Xmobar.Plugins.Monitors.Mem.Linux Xmobar.Plugins.Monitors.Net.Linux
    Xmobar.Plugins.Monitors.Swap.Linux
    Xmobar.Plugins.Monitors.Top.Linux
    Xmobar.Plugins.Monitors.Uptime.Linux

import-dirs:          /usr/lib/ghc-9.2.8/site-local/xmobar-0.48.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/xmobar-0.48.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.2.8/xmobar-0.48.1
hs-libraries:         HSxmobar-0.48.1-3I4VXAwIEwy8YBtTtFl6of
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.10.3-8NdPo2dy5eHGXd7RnXiWFu
    X11-xft-0.3.4-98YLZVy2qHCY5tIyZFoYm
    aeson-2.1.2.1-IkP1OjeNuTxglWxWeIvI9
    alsa-core-0.5.0.1-17RPPLKQvJD1CG7D20QmIG
    alsa-mixer-0.3.0.1-1KxmuurdBLpGRGNO2LOWxI
    async-2.2.5-A9yY3sStrUyIJcfOkNbDOv base-4.16.4.0
    bytestring-0.11.4.0 cairo-0.13.10.0-ATKdEtWFarpJ0bXXaORFAE
    cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    colour-2.3.6-KDhjTRIL7rnBhoKfQ21QbO containers-0.6.5.1
    dbus-1.3.1-KoOZxxixWTX8GXkbaBOosy directory-1.3.6.2
    extensible-exceptions-0.1.1.4-D8VRIfPBfkhEPmMrxbU9lA
    extra-1.7.16-HmT1ExbMa8s7Fr43bhn74d filepath-1.4.2.2
    hinotify-0.4.1-6oQ67Wbqxj4BCNsarV7XG
    http-client-tls-0.3.6.3-2EQqEGNQgqBeXR2SFRRfB
    http-conduit-2.3.9-GK62BVohZn1GCLNLtPOE4B
    http-types-0.12.4-6kOruwBLItLEcotK7uAwKL
    libmpd-0.10.0.0-6XE6wFW0tGCJAFfL0Iqmju mtl-2.2.2
    netlink-1.1.1.0-HQc0LZUzafRLOrLetxcbYT
    old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7
    pango-0.13.11.0-Hzfun0YoDud7hzLZiiDsmp parsec-3.1.15.0
    parsec-numbers-0.1.0-69YJg6wFQCK4vrakylRSsT process-1.6.16.0
    regex-compat-0.95.2.1-6r4iKSNuQHkEjgz1ilm8wy stm-2.5.0.2
    time-1.11.1.1 timezone-olson-0.2.1-JZvcsqhYOAiEwiQhSiFRSg
    timezone-series-0.1.13-8lxErw9wrLf6Z6J89uOObG transformers-0.5.6.2
    unix-2.7.2.2 utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:
    /usr/share/doc/x86_64-linux-ghc-9.2.8/xmobar-0.48.1/html/xmobar.haddock

haddock-html:         /usr/share/doc/x86_64-linux-ghc-9.2.8/xmobar-0.48.1/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

