#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Zed
# send your bug reports to contact@dotslashplay.it
###

script_version=20230712.2

GAME_ID='zed-game'
GAME_NAME='Zed'

ARCHIVE_BASE_0='zed_1_3_30662.sh'
ARCHIVE_BASE_0_MD5='bc70e3f8b20dd9998972e973349be9c1'
ARCHIVE_BASE_0_SIZE='11000000'
ARCHIVE_BASE_0_VERSION='1.3-gog30662'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/zed'

UNREALENGINE4_NAME='zed'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_DATA_CHUNK1_FILES="
${UNREALENGINE4_NAME}/Content/Paks/pakchunk0-LinuxNoEditor.pak.split00
${UNREALENGINE4_NAME}/Content/Paks/pakchunk0-LinuxNoEditor.pak.split01"
CONTENT_GAME_DATA_CHUNK2_FILES="
${UNREALENGINE4_NAME}/Content/Paks/pakchunk0-LinuxNoEditor.pak.split02"

APPLICATIONS_PREFIX_TYPE='none'

APP_MAIN_EXE="${UNREALENGINE4_NAME}/Binaries/Linux/${UNREALENGINE4_NAME}-Linux-Shipping"
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA_CHUNK1 PKG_DATA_CHUNK2 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_DATA_CHUNK1_ID="${PKG_DATA_ID}-chunk1"
PKG_DATA_CHUNK1_DESCRIPTION="$PKG_DATA_DESCRIPTION - chunk 1"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_CHUNK1_ID"

PKG_DATA_CHUNK2_ID="${PKG_DATA_ID}-chunk2"
PKG_DATA_CHUNK2_DESCRIPTION="$PKG_DATA_DESCRIPTION - chunk 2"
PKG_DATA_DEPS="$PKG_DATA_DEPS $PKG_DATA_CHUNK2_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'

# Load common functions

target_version='2.25'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Set package scripts to rebuild the full files from their chunks

file_path="${UNREALENGINE4_NAME}/Content/Paks/pakchunk0-LinuxNoEditor.pak"
PKG_DATA_POSTINST_RUN="${PKG_DATA_POSTINST_RUN:-}
$(huge_file_concatenate "$file_path")"
PKG_DATA_CHUNK1_PRERM_RUN="${PKG_DATA_CHUNK1_PRERM_RUN:-}
$(huge_file_delete "$file_path")"
PKG_DATA_CHUNK2_PRERM_RUN="${PKG_DATA_CHUNK2_PRERM_RUN:-}
$(huge_file_delete "$file_path")"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
# shellcheck disable=SC2119
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
# shellcheck disable=SC2119
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
