/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "Prop.hpp"


namespace MsXpS
{

namespace libXpertMass
{


  //! The PropList class provides a list of allocated Prop instances.
  /*! PropList provides a list of allocated Prop instances that it
    owns. This class is used to derive classes needing to store
    dynamically allocated Prop objects without knowing with
    anticipation how many of such objects are going to be used.
  */
  class DECLSPEC PropListHolder
  {
    public:
    PropListHolder();
    PropListHolder(const PropListHolder &other);
    virtual ~PropListHolder();

    virtual PropListHolder &operator=(const PropListHolder &other);

    const QList<Prop *> &propList() const;
    QList<Prop *> &propList();

    Prop *prop(const QString &, int * = 0);
    int propIndex(const QString &, Prop * = 0);

    int propListSize() const;

    bool appendProp(Prop *);
    bool removeProp(Prop *);
    bool removeProp(const QString &);

    protected:
    QList<Prop *> m_propList;
  };

} // namespace libXpertMass

} // namespace MsXpS

