      SUBROUTINE BMGTNS(CSTM,NCSTM,ECPT,TA)
C/// THIS ROUTINE WAS LIFTED FROM PRETRD AND TRANSD AND CONVERTED
C///// TO HAVE ONE ENTRY POINT
C
C PRETRD SETS UP EVENTUAL CALLS TO TRANSD.  FOR A MODULE TO USE TRANSD
C A CALL TO PRETRD MUST BE INITIATED BY THE MODULE DRIVER ONCE AND ONLY
C ONCE.  CSTM IS ARRAY OF COORDINATE SYSTEM TRANSFORMATION MATRICES
C AND NCSTM IS THE LENGTH OF THIS ARRAY.
C
      DIMENSION          CSTM(1)
C*****
C GIVEN THE ECPT ARRAY OF LENGTH 4, THE FIRST WORD BEING AN INTEGER
C COORDINATE SYSTEM IDENTIFICATION NUMBER AND THE NEXT WORDS BEING THE
C REAL COORDINATES OF A POINT IN BASIC COORDINATES, THIS ROUTINE
C COMPUTES THE TRANSFORMATION (DIRECTION COSINE) MATRIX TA WHICH WILL
C MAP A VECTOR FROM THE LOCAL SYSTEM LABELED ECPT(1) TO BASIC COORDI-
C NATES.  TA IS A DOUBLE PRECISION MATRIX.
C*****
      DIMENSION          ECPT(4)
C
      DOUBLE PRECISION
     1                   TA(9)              ,TL(9)
     2,                  XN(3)              ,X
     3,                  Y                  ,Z
     4,                  R                  ,KE(9)
     5,                  XL
C
      EQUIVALENCE        (FL1,INT1)         ,(FL2,INT2)
C
      FL1 = ECPT(1)
      IF(INT1.EQ.0) GO TO 13
      DO 6 I = 1,NCSTM,14
      FL2 = CSTM(I)
      IF(INT1.NE.INT2) GO TO 6
      KK = I
      FL2 = CSTM(I + 1)
      GO TO (7,10,10),INT2
    6 CONTINUE
C
C THE COORDINATE SYSTEM ID. COULD NOT BE FOUND IN THE CSTM.
C
      CALL MESAGE (-30,25,INT1)
C
C THE COORDINATE SYSTEM IS RECTANGULAR.
C
    7 DO 8 J = 1,9
      K = KK + 4 + J
    8 TA(J) = CSTM(K)
      RETURN
   10 XN(1) = ECPT(2) - CSTM(KK+2)
      XN(2) = ECPT(3) - CSTM(KK+3)
      XN(3) = ECPT(4) - CSTM(KK + 4)
      X = CSTM(KK+5)*XN(1)+CSTM(KK+8)*XN(2)+CSTM(KK+11)*XN(3)
      Y = CSTM(KK+6)*XN(1)+CSTM(KK+9)*XN(2)+CSTM(KK+12)*XN(3)
      Z = CSTM(KK+7)*XN(1)+CSTM(KK+10)*XN(2)+CSTM(KK+13)*XN(3)
      R = DSQRT(X**2+Y**2)
      IF (R .EQ. 0.0D0) GO TO 7
      DO 110 J=1,9
      K=KK+4+J
  110 KE(J)=CSTM(K)
      GO TO (11,11,12),INT2
C
C THE COORDINATE SYSTEM IS CYLINDRICAL.
C
   11 TL(1)=X/R
      TL(2)=-Y/R
      TL(3)=0.0D0
      TL(4)=-TL(2)
      TL(5)=TL(1)
      TL(6)=0.0D0
      TL(7)=0.0D0
      TL(8)=0.0D0
      TL(9)=1.0D0
      GO TO 125
C
C THE COORDINATE SYSTEM IS SPHERICAL.
C
   12 XL=DSQRT(X*X+Y*Y+Z*Z)
      TL(1)=X/XL
      TL(2)=(X*Z)/(R*XL)
      TL(3)=-Y/R
      TL(4)=Y/XL
      TL(5)=(Y*Z)/(R*XL)
      TL(6)=X/R
      TL(7)=Z/XL
      TL(8)=-R/XL
      TL(9)=0.0D0
  125 CALL GMMATD (KE(1),3,3,0, TL(1),3,3,0, TA(1))
      RETURN
C
C THE LOCAL SYSTEM IS BASIC.
C
   13 DO 14 I=1,9
   14 TA(I)=0.0D0
      TA(1)=1.0D0
      TA(5)=1.0D0
      TA(9)=1.0D0
      RETURN
      END
