/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2022  Intel Corporation. All rights reserved.
 *  Copyright 2024 NXP
 *
 */

#define LC3_ID			0x06

#define LC3_BASE		0x01

#define LC3_FREQ		(LC3_BASE)
#define LC3_FREQ_8KHZ		BIT(0)
#define LC3_FREQ_11KHZ		BIT(1)
#define LC3_FREQ_16KHZ		BIT(2)
#define LC3_FREQ_22KHZ		BIT(3)
#define LC3_FREQ_24KHZ		BIT(4)
#define LC3_FREQ_32KHZ		BIT(5)
#define LC3_FREQ_44KHZ		BIT(6)
#define LC3_FREQ_48KHZ		BIT(7)
#define LC3_FREQ_ANY		(LC3_FREQ_8KHZ | \
					LC3_FREQ_11KHZ | \
					LC3_FREQ_16KHZ | \
					LC3_FREQ_22KHZ | \
					LC3_FREQ_24KHZ | \
					LC3_FREQ_32KHZ | \
					LC3_FREQ_44KHZ | \
					LC3_FREQ_48KHZ)

#define LC3_DURATION		(LC3_BASE + 1)
#define LC3_DURATION_7_5	BIT(0)
#define LC3_DURATION_10		BIT(1)
#define LC3_DURATION_ANY	(LC3_DURATION_7_5 | LC3_DURATION_10)
#define LC3_DURATION_PREFER_7_5	BIT(4)
#define LC3_DURATION_PREFER_10	BIT(5)


#define LC3_CHAN_COUNT		(LC3_BASE + 2)
#define LC3_CHAN_COUNT_SUPPORT	BIT(0)

#define LC3_FRAME_LEN		(LC3_BASE + 3)

#define LC3_FRAME_COUNT		(LC3_BASE + 4)

#define LC3_CAPABILITIES(_freq, _duration, _chan_count, _len_min, _len_max) \
	UTIL_IOV_INIT(0x02, LC3_FREQ, _freq, _freq >> 8, \
			0x02, LC3_DURATION, _duration, \
			0x02, LC3_CHAN_COUNT, _chan_count, \
			0x05, LC3_FRAME_LEN, _len_min, _len_min >> 8, \
			_len_max, _len_max >> 8)

#define LC3_CONFIG_BASE		0x01

#define LC3_CONFIG_FREQ		(LC3_CONFIG_BASE)
#define LC3_CONFIG_FREQ_8KHZ	0x01
#define LC3_CONFIG_FREQ_11KHZ	0x02
#define LC3_CONFIG_FREQ_16KHZ	0x03
#define LC3_CONFIG_FREQ_22KHZ	0x04
#define LC3_CONFIG_FREQ_24KHZ	0x05
#define LC3_CONFIG_FREQ_32KHZ	0x06
#define LC3_CONFIG_FREQ_44KHZ	0x07
#define LC3_CONFIG_FREQ_48KHZ	0x08

#define LC3_CONFIG_DURATION	(LC3_CONFIG_BASE + 1)
#define LC3_CONFIG_DURATION_7_5	0x00
#define LC3_CONFIG_DURATION_10	0x01

#define LC3_CONFIG_CHAN_ALLOC		(LC3_CONFIG_BASE + 2)
#define LC3_CONFIG_CHAN_ALLOC_LEN	0x05

#define LC3_CONFIG_FRAME_LEN	(LC3_CONFIG_BASE + 3)

#define LC3_CONFIG(_freq, _duration, _len) \
	UTIL_IOV_INIT(0x02, LC3_CONFIG_FREQ, _freq, \
			0x02, LC3_CONFIG_DURATION, _duration, \
			0x03, LC3_CONFIG_FRAME_LEN, _len, _len >> 8)

#define LC3_AC_BITS(_ac) (BIT(_ac) - 1)

#define LC3_CONFIG_AC(_freq, _duration, _len, _ac) \
	UTIL_IOV_INIT(0x02, LC3_CONFIG_FREQ, _freq, \
			0x02, LC3_CONFIG_DURATION, _duration, \
			0x03, LC3_CONFIG_FRAME_LEN, _len, _len >> 8, \
			0x05, LC3_CONFIG_CHAN_ALLOC, LC3_AC_BITS(_ac), \
			LC3_AC_BITS(_ac) >> 8 & 0xff, \
			LC3_AC_BITS(_ac) >> 16 & 0xff, \
			LC3_AC_BITS(_ac) >> 24 & 0xff)

#define LC3_CONFIG_8(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_8KHZ, _duration, _len)

#define LC3_CONFIG_8_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_8KHZ, _duration, _len, _ac)

#define LC3_CONFIG_11(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_11KHZ, _duration, _len)

#define LC3_CONFIG_11_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_11KHZ, _duration, _len, _ac)

#define LC3_CONFIG_16(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_16KHZ, _duration, _len)

#define LC3_CONFIG_16_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_16KHZ, _duration, _len, _ac)

#define LC3_CONFIG_22(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_22KHZ, _duration, _len)

#define LC3_CONFIG_22_AC(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_22KHZ, _duration, _len, _ac)

#define LC3_CONFIG_24(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_24KHZ, _duration, _len)

#define LC3_CONFIG_24_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_24KHZ, _duration, _len, _ac)

#define LC3_CONFIG_32(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_32KHZ, _duration, _len)

#define LC3_CONFIG_32_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_32KHZ, _duration, _len, _ac)

#define LC3_CONFIG_44(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_44KHZ, _duration, _len)

#define LC3_CONFIG_44_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_44KHZ, _duration, _len, _ac)

#define LC3_CONFIG_48(_duration, _len) \
	LC3_CONFIG(LC3_CONFIG_FREQ_48KHZ, _duration, _len)

#define LC3_CONFIG_48_AC(_duration, _len, _ac) \
	LC3_CONFIG_AC(LC3_CONFIG_FREQ_48KHZ, _duration, _len, _ac)

#define LC3_CONFIG_FRAME_LEN_8_1 26u

#define LC3_CONFIG_8_1 \
	LC3_CONFIG_8(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_8_1)

#define LC3_CONFIG_8_1_AC(_ac) \
	LC3_CONFIG_8_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_8_1, _ac)

#define LC3_CONFIG_FRAME_LEN_8_2 30u

#define LC3_CONFIG_8_2 \
	LC3_CONFIG_8(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_8_2 )

#define LC3_CONFIG_8_2_AC(_ac) \
	LC3_CONFIG_8_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_8_2, _ac)

#define LC3_CONFIG_FRAME_LEN_16_1 30u

#define LC3_CONFIG_16_1 \
	LC3_CONFIG_16(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_16_1)

#define LC3_CONFIG_16_1_AC(_ac) \
	LC3_CONFIG_16_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_16_1, \
			_ac)

#define LC3_CONFIG_FRAME_LEN_16_2 40u

#define LC3_CONFIG_16_2 \
	LC3_CONFIG_16(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_16_2)

#define LC3_CONFIG_16_2_AC(_ac) \
	LC3_CONFIG_16_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_16_2, _ac)

#define LC3_CONFIG_FRAME_LEN_24_1 45u

#define LC3_CONFIG_24_1 \
	LC3_CONFIG_24(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_24_1)

#define LC3_CONFIG_24_1_AC(_ac) \
	LC3_CONFIG_24_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_24_1, \
			_ac)

#define LC3_CONFIG_FRAME_LEN_24_2 60u

#define LC3_CONFIG_24_2 \
	LC3_CONFIG_24(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_24_2)

#define LC3_CONFIG_24_2_AC(_ac) \
	LC3_CONFIG_24_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_24_2, _ac)

#define LC3_CONFIG_FRAME_LEN_32_1 60u

#define LC3_CONFIG_32_1 \
	LC3_CONFIG_32(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_32_1)

#define LC3_CONFIG_32_1_AC(_ac) \
	LC3_CONFIG_32_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_32_1, \
			_ac)

#define LC3_CONFIG_FRAME_LEN_32_2 80u

#define LC3_CONFIG_32_2 \
	LC3_CONFIG_32(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_32_2)

#define LC3_CONFIG_32_2_AC(_ac) \
	LC3_CONFIG_32_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_32_2, _ac)

#define LC3_CONFIG_FRAME_LEN_44_1 98u

#define LC3_CONFIG_44_1 \
	LC3_CONFIG_44(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_44_1)

#define LC3_CONFIG_44_1_AC(_ac) \
	LC3_CONFIG_44_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_44_1, \
			 _ac)

#define LC3_CONFIG_FRAME_LEN_44_2 130u

#define LC3_CONFIG_44_2 \
	LC3_CONFIG_44(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_44_2)

#define LC3_CONFIG_44_2_AC(_ac) \
	LC3_CONFIG_44_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_44_2, _ac)

#define LC3_CONFIG_FRAME_LEN_48_1 75u

#define LC3_CONFIG_48_1 \
	LC3_CONFIG_48(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_48_1)

#define LC3_CONFIG_48_1_AC(_ac) \
	LC3_CONFIG_48_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_48_1, \
			_ac)

#define LC3_CONFIG_FRAME_LEN_48_2 100u

#define LC3_CONFIG_48_2 \
	LC3_CONFIG_48(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_48_2)

#define LC3_CONFIG_48_2_AC(_ac) \
	LC3_CONFIG_48_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_48_2, _ac)

#define LC3_CONFIG_FRAME_LEN_48_3 90u

#define LC3_CONFIG_48_3 \
	LC3_CONFIG_48(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_48_3)

#define LC3_CONFIG_48_3_AC(_ac) \
	LC3_CONFIG_48_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_48_3, \
			_ac)

#define LC3_CONFIG_FRAME_LEN_48_4 120u

#define LC3_CONFIG_48_4 \
	LC3_CONFIG_48(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_48_4)

#define LC3_CONFIG_48_4_AC(_ac) \
	LC3_CONFIG_48_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_48_4, _ac)

#define LC3_CONFIG_FRAME_LEN_48_5 117u

#define LC3_CONFIG_48_5 \
	LC3_CONFIG_48(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_48_5)

#define LC3_CONFIG_48_5_AC(_ac) \
	LC3_CONFIG_48_AC(LC3_CONFIG_DURATION_7_5, LC3_CONFIG_FRAME_LEN_48_5, \
			_ac)

#define LC3_CONFIG_FRAME_LEN_48_6 155u

#define LC3_CONFIG_48_6 \
	LC3_CONFIG_48(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_48_6)

#define LC3_CONFIG_48_6_AC(_ac) \
	LC3_CONFIG_48_AC(LC3_CONFIG_DURATION_10, LC3_CONFIG_FRAME_LEN_48_6, \
			_ac)

#define LC3_QOS_UNFRAMED	0x00
#define LC3_QOS_FRAMED		0x01

#define LC3_QOS_UCAST(_frame, _pd, _t_lat, _interval, _lat, _sdu, _rtn) \
{ \
	.ucast.cig_id = 0x00, \
	.ucast.cis_id = 0x00, \
	.ucast.delay = _pd, \
	.ucast.target_latency = _t_lat, \
	.ucast.io_qos.interval = _interval, \
	.ucast.io_qos.latency = _lat, \
	.ucast.io_qos.sdu = _sdu, \
	.ucast.io_qos.phy = BT_BAP_CONFIG_PHY_2M, \
	.ucast.io_qos.rtn = _rtn, \
}

#define LC3_QOS_UCAST_7_5_UNFRAMED(_pd, _t_lat, _lat, _sdu, _rtn) \
	LC3_QOS_UCAST(LC3_QOS_UNFRAMED, _pd, _t_lat, 7500u, _lat, _sdu, _rtn)

#define LC3_QOS_UCAST_10_UNFRAMED(_pd, _t_lat, _lat, _sdu, _rtn) \
	LC3_QOS_UCAST(LC3_QOS_UNFRAMED, _pd, _t_lat, 10000u, _lat, _sdu, _rtn)

#define LC3_QOS_UCAST_FRAMED(_pd, _t_lat, _interval, _lat, _sdu, _rtn) \
	LC3_QOS_UCAST(LC3_QOS_FRAMED, _pd, _t_lat, _interval, _lat, _sdu, _rtn)

#define LC3_QOS_8_1_1_LATENCY 8u
#define LC3_QOS_8_1_1_RTN 2u

#define LC3_QOS_8_1_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_8_1_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_8_1, \
					LC3_QOS_8_1_1_RTN)
#define LC3_QOS_8_1_1 LC3_QOS_8_1_1_AC(1)

#define LC3_QOS_8_1_2_LATENCY 75u
#define LC3_QOS_8_1_2_RTN 13u

#define LC3_QOS_8_1_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_8_1_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_8_1, \
					LC3_QOS_8_1_2_RTN)
#define LC3_QOS_8_1_2 LC3_QOS_8_1_2_AC(1)

#define LC3_QOS_8_2_1_LATENCY 10u
#define LC3_QOS_8_2_1_RTN 2u

#define LC3_QOS_8_2_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_8_2_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_8_2, \
					LC3_QOS_8_2_1_RTN)
#define LC3_QOS_8_2_1 LC3_QOS_8_2_1_AC(1)

#define LC3_QOS_8_2_2_LATENCY 95u
#define LC3_QOS_8_2_2_RTN 13u

#define LC3_QOS_8_2_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_8_2_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_8_2, \
					LC3_QOS_8_2_2_RTN)
#define LC3_QOS_8_2_2 LC3_QOS_8_2_2_AC(1)

#define LC3_QOS_16_1_1_LATENCY 8u
#define LC3_QOS_16_1_1_RTN 2u

#define LC3_QOS_16_1_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_16_1_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_16_1, \
					LC3_QOS_16_1_1_RTN)
#define LC3_QOS_16_1_1 LC3_QOS_16_1_1_AC(1)

#define LC3_QOS_16_1_2_LATENCY 75u
#define LC3_QOS_16_1_2_RTN 13u

#define LC3_QOS_16_1_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_16_1_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_16_1, \
					LC3_QOS_16_1_2_RTN)
#define LC3_QOS_16_1_2 LC3_QOS_16_1_2_AC(1)

#define LC3_QOS_16_2_1_LATENCY 10u
#define LC3_QOS_16_2_1_RTN 2u

#define LC3_QOS_16_2_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_16_2_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_16_2, \
					LC3_QOS_16_2_1_RTN)
#define LC3_QOS_16_2_1 LC3_QOS_16_2_1_AC(1)

#define LC3_QOS_16_2_2_LATENCY 95u
#define LC3_QOS_16_2_2_RTN 13u

#define LC3_QOS_16_2_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_16_2_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_16_2, \
					LC3_QOS_16_2_2_RTN)
#define LC3_QOS_16_2_2 LC3_QOS_16_2_2_AC(1)

#define LC3_QOS_24_1_1_LATENCY 8u
#define LC3_QOS_24_1_1_RTN 2u

#define LC3_QOS_24_1_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_24_1_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_24_1, 2u)
#define LC3_QOS_24_1_1 LC3_QOS_24_1_1_AC(1)

#define LC3_QOS_24_1_2_LATENCY 75u
#define LC3_QOS_24_1_2_RTN 13u

#define LC3_QOS_24_1_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_24_1_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_24_1, \
					LC3_QOS_24_1_2_RTN)
#define LC3_QOS_24_1_2 LC3_QOS_24_1_2_AC(1)

#define LC3_QOS_24_2_1_LATENCY 10u
#define LC3_QOS_24_2_1_RTN 2u

#define LC3_QOS_24_2_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_24_2_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_24_2, \
					LC3_QOS_24_2_1_RTN)
#define LC3_QOS_24_2_1 LC3_QOS_24_2_1_AC(1)

#define LC3_QOS_24_2_2_LATENCY 95u
#define LC3_QOS_24_2_2_RTN 13u

#define LC3_QOS_24_2_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_24_2_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_24_2, \
					LC3_QOS_24_2_2_RTN)
#define LC3_QOS_24_2_2 LC3_QOS_24_2_2_AC(1)

#define LC3_QOS_32_1_1_LATENCY 8u
#define LC3_QOS_32_1_1_RTN 2u

#define LC3_QOS_32_1_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_32_1_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_32_1, \
					LC3_QOS_32_1_1_RTN)
#define LC3_QOS_32_1_1 LC3_QOS_32_1_1_AC(1)

#define LC3_QOS_32_1_2_LATENCY 75u
#define LC3_QOS_32_1_2_RTN 13u

#define LC3_QOS_32_1_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_32_1_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_32_1, \
					LC3_QOS_32_1_2_RTN)
#define LC3_QOS_32_1_2 LC3_QOS_32_1_2_AC(1)

#define LC3_QOS_32_2_1_LATENCY 10u
#define LC3_QOS_32_2_1_RTN 2u

#define LC3_QOS_32_2_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_32_2_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_32_2, \
					LC3_QOS_32_2_1_RTN)
#define LC3_QOS_32_2_1 LC3_QOS_32_2_1_AC(1)

#define LC3_QOS_32_2_2_LATENCY 95u
#define LC3_QOS_32_2_2_RTN 13u

#define LC3_QOS_32_2_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_32_2_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_32_2, \
					LC3_QOS_32_2_2_RTN)
#define LC3_QOS_32_2_2 LC3_QOS_32_2_2_AC(1)

#define LC3_QOS_44_1_INTERVAL 8163u
#define LC3_QOS_44_1_1_LATENCY 24u
#define LC3_QOS_44_1_1_RTN 5u

#define LC3_QOS_44_1_1_AC(_ac) \
	LC3_QOS_UCAST_FRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_44_1_INTERVAL, \
					LC3_QOS_44_1_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_44_1, \
					LC3_QOS_44_1_1_RTN)
#define LC3_QOS_44_1_1 LC3_QOS_44_1_1_AC(1)

#define LC3_QOS_44_1_2_LATENCY 80u
#define LC3_QOS_44_1_2_RTN 13u

#define LC3_QOS_44_1_2_AC(_ac) \
	LC3_QOS_UCAST_FRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_44_1_INTERVAL, \
					LC3_QOS_44_1_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_44_1, \
					LC3_QOS_44_1_2_RTN)
#define LC3_QOS_44_1_2 LC3_QOS_44_1_2_AC(1)

#define LC3_QOS_44_2_INTERVAL 10884u
#define LC3_QOS_44_2_1_LATENCY 31u
#define LC3_QOS_44_2_1_RTN 5u

#define LC3_QOS_44_2_1_AC(_ac) \
	LC3_QOS_UCAST_FRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_44_2_INTERVAL, \
					LC3_QOS_44_2_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_44_2, \
					LC3_QOS_44_2_1_RTN)
#define LC3_QOS_44_2_1 LC3_QOS_44_2_1_AC(1)

#define LC3_QOS_44_2_2_LATENCY 85u
#define LC3_QOS_44_2_2_RTN 13u

#define LC3_QOS_44_2_2_AC(_ac) \
	LC3_QOS_UCAST_FRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_44_2_INTERVAL, \
					LC3_QOS_44_2_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_44_2, \
					LC3_QOS_44_2_2_RTN)
#define LC3_QOS_44_2_2 LC3_QOS_44_2_2_AC(1)

#define LC3_QOS_48_1_1_LATENCY 15u
#define LC3_QOS_48_1_1_RTN 5u

#define LC3_QOS_48_1_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_1_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_1,\
					LC3_QOS_48_1_1_RTN)
#define LC3_QOS_48_1_1 LC3_QOS_48_1_1_AC(1)

#define LC3_QOS_48_1_2_LATENCY 75u
#define LC3_QOS_48_1_2_RTN 13u

#define LC3_QOS_48_1_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_1_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_1, \
					LC3_QOS_48_1_2_RTN)
#define LC3_QOS_48_1_2 LC3_QOS_48_1_2_AC(1)

#define LC3_QOS_48_2_1_LATENCY 20u
#define LC3_QOS_48_2_1_RTN 5u

#define LC3_QOS_48_2_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_2_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_2, \
					LC3_QOS_48_2_1_RTN)
#define LC3_QOS_48_2_1 LC3_QOS_48_2_1_AC(1)

#define LC3_QOS_48_2_2_LATENCY 95u
#define LC3_QOS_48_2_2_RTN 13u

#define LC3_QOS_48_2_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_2_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_2, \
					LC3_QOS_48_2_2_RTN)
#define LC3_QOS_48_2_2 LC3_QOS_48_2_2_AC(1)

#define LC3_QOS_48_3_1_LATENCY 15u
#define LC3_QOS_48_3_1_RTN 5u

#define LC3_QOS_48_3_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_3_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_3, \
					LC3_QOS_48_3_1_RTN)
#define LC3_QOS_48_3_1 LC3_QOS_48_3_1_AC(1)

#define LC3_QOS_48_3_2_LATENCY 75u
#define LC3_QOS_48_3_2_RTN 13u

#define LC3_QOS_48_3_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_3_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_3, \
					LC3_QOS_48_3_2_RTN)
#define LC3_QOS_48_3_2 LC3_QOS_48_3_2_AC(1)

#define LC3_QOS_48_4_1_LATENCY 20u
#define LC3_QOS_48_4_1_RTN 5u

#define LC3_QOS_48_4_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_4_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_4, \
					LC3_QOS_48_4_1_RTN)
#define LC3_QOS_48_4_1 LC3_QOS_48_4_1_AC(1)

#define LC3_QOS_48_4_2_LATENCY 100u
#define LC3_QOS_48_4_2_RTN 13u

#define LC3_QOS_48_4_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_4_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_4, \
					LC3_QOS_48_4_2_RTN)
#define LC3_QOS_48_4_2 LC3_QOS_48_4_2_AC(1)

#define LC3_QOS_48_5_1_LATENCY 15u
#define LC3_QOS_48_5_1_RTN 5u

#define LC3_QOS_48_5_1_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_5_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_5, \
					LC3_QOS_48_5_1_RTN)
#define LC3_QOS_48_5_1 LC3_QOS_48_5_1_AC(1)

#define LC3_QOS_48_5_2_LATENCY 75u
#define LC3_QOS_48_5_2_RTN 13u

#define LC3_QOS_48_5_2_AC(_ac) \
	LC3_QOS_UCAST_7_5_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_5_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_5, \
					LC3_QOS_48_5_2_RTN)
#define LC3_QOS_48_5_2 LC3_QOS_48_5_2_AC(1)

#define LC3_QOS_48_6_1_LATENCY 20u
#define LC3_QOS_48_6_1_RTN 5u

#define LC3_QOS_48_6_1_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_6_1_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_6, \
					LC3_QOS_48_6_1_RTN)
#define LC3_QOS_48_6_1 LC3_QOS_48_6_1_AC(1)

#define LC3_QOS_48_6_2_LATENCY 100u
#define LC3_QOS_48_6_2_RTN 13u

#define LC3_QOS_48_6_2_AC(_ac) \
	LC3_QOS_UCAST_10_UNFRAMED(40000u, BT_BAP_CONFIG_LATENCY_BALANCED, \
					LC3_QOS_48_6_2_LATENCY, \
					_ac * LC3_CONFIG_FRAME_LEN_48_6, \
					LC3_QOS_48_6_2_RTN)
#define LC3_QOS_48_6_2 LC3_QOS_48_6_2_AC(1)
