/*
 * 	log.c - logging functions for lockd/statd
 *
 *	260295	 okir	started with simply syslog logging.
 *                      Various minor mod's by Jeff Uphoff.
 *
 * $Id: log.c,v 2.2 1997/12/25 00:38:30 juphoff Exp $
 */

#include <syslog.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#include <sys/types.h>

#include "log.h"

static char	progname[256];
static pid_t	mypid;
                                /* Turns on logging to console/stderr. */
static int	opt_debug = 0;	/* Will be command-line option, eventually */

void
log_init(char *name)
{
    char	*sp;

    openlog(name, LOG_PID, LOG_LOCAL5);
    if ((sp = strrchr(name, '/')) != NULL)
	name = ++sp;
    strncpy(progname, name, 255);
    progname[255] = '\0';
    mypid = getpid();
}

void
log_background(void)
{
    /* NOP */
}

void
log_enable(int level)
{
    opt_debug = 1;
}

int
log_enabled(int level)
{
    return opt_debug;
}

void
die(char *fmt, ...)
{
    char	buffer[1024];
    va_list	ap;

    va_start(ap, fmt);
    vsprintf (buffer, fmt, ap);
    va_end(ap);

    log(L_FATAL, "%s", buffer);

#ifndef DEBUG
    exit (2);
#else
    abort();	/* make a core */
#endif
}

void
log(int level, char *fmt, ...)
{
    char	buffer[1024];
    va_list	ap;

    va_start(ap, fmt);
    vsprintf (buffer, fmt, ap);
    va_end(ap);

    if (level < L_DEBUG) {
    	syslog(level, buffer);
    }

    if (opt_debug) {
        time_t		now;
        struct tm *	tm;

        time(&now);
        tm = localtime(&now);
        fprintf (stderr, "%02d.%02d.%02d %02d:%02d:%02d %s[%d]: %s\n",
			tm->tm_mday, tm->tm_mon, tm->tm_year,
			tm->tm_hour, tm->tm_min, tm->tm_sec,
			progname, mypid,
			buffer);
    }
}
