// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, FwNode};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    /// A transaction responder for request subaction initiated by node in IEEE 1394 bus.
    ///
    /// [`FwResp`][crate::FwResp] responds to request subaction initiated by node in IEEE 1394 bus.
    ///
    /// ## Properties
    ///
    ///
    /// #### `is-reserved`
    ///  Whether a range of address is reserved or not.
    ///
    /// Readable
    ///
    ///
    /// #### `offset`
    ///  The start offset of reserved address range.
    ///
    /// Readable
    ///
    ///
    /// #### `width`
    ///  The width of reserved address range.
    ///
    /// Readable
    ///
    /// ## Signals
    ///
    ///
    /// #### `requested`
    ///  Emitted when any node transfers request subaction to local nodes within the address
    /// range reserved in Linux system.
    ///
    /// The handler is expected to call [`FwRespExt::set_resp_frame()`][crate::prelude::FwRespExt::set_resp_frame()] with frame and return
    /// [`FwRcode`][crate::FwRcode] for response subaction.
    ///
    /// The value of @tstamp is unsigned 16 bit integer including higher 3 bits for three low
    /// order bits of second field and the rest 13 bits for cycle field in the format of IEEE
    /// 1394 CYCLE_TIMER register.
    ///
    /// If the version of kernel ABI for Linux FireWire subsystem is less than 6, the value of
    /// tstamp argument has invalid value (=G_MAXUINT). Furthermore, if the version is less than
    /// 4, the src, dst, card, generation arguments have invalid value (=G_MAXUINT).
    ///
    ///
    ///
    /// # Implements
    ///
    /// [`FwRespExt`][trait@crate::prelude::FwRespExt], [`FwRespExtManual`][trait@crate::prelude::FwRespExtManual]
    #[doc(alias = "HinawaFwResp")]
    pub struct FwResp(Object<ffi::HinawaFwResp, ffi::HinawaFwRespClass>);

    match fn {
        type_ => || ffi::hinawa_fw_resp_get_type(),
    }
}

impl FwResp {
    pub const NONE: Option<&'static FwResp> = None;

    /// Instantiate [`FwResp`][crate::FwResp] object and return the instance.
    ///
    /// # Returns
    ///
    /// a new instance of [`FwResp`][crate::FwResp].
    #[doc(alias = "hinawa_fw_resp_new")]
    pub fn new() -> FwResp {
        unsafe { from_glib_full(ffi::hinawa_fw_resp_new()) }
    }
}

impl Default for FwResp {
    fn default() -> Self {
        Self::new()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::FwResp>> Sealed for T {}
}

/// Trait containing the part of [`struct@FwResp`] methods.
///
/// # Implementors
///
/// [`FwFcp`][struct@crate::FwFcp], [`FwResp`][struct@crate::FwResp]
pub trait FwRespExt: IsA<FwResp> + sealed::Sealed + 'static {
    /// Stop listening to the address range in Linux system for local nodes.
    #[doc(alias = "hinawa_fw_resp_release")]
    fn release(&self) {
        unsafe {
            ffi::hinawa_fw_resp_release(self.as_ref().to_glib_none().0);
        }
    }

    /// Allocate an address range within Linux system for local nodes, each of which expresses 1394
    /// OHCI hardware. Once successful, [`requested`][struct@crate::FwResp#requested] signal will be emitted whenever any
    /// request subactions arrive at the 1394 OHCI hardware within the dedicated range.
    ///
    /// The range is precisely reserved at the address specified by @addr with the size indicated by
    /// @width. In essence, this function is a variant of [`reserve_within_region()`][Self::reserve_within_region()] in
    /// which the specified address range is reserved as provided.
    /// ## `node`
    /// A [`FwNode`][crate::FwNode].
    /// ## `addr`
    /// A start address to listen to in 1394 OHCI hardware.
    /// ## `width`
    /// The byte width of address to listen to 1394 OHCI hardware.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinawa_fw_resp_reserve")]
    fn reserve(&self, node: &impl IsA<FwNode>, addr: u64, width: u32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::hinawa_fw_resp_reserve(
                self.as_ref().to_glib_none().0,
                node.as_ref().to_glib_none().0,
                addr,
                width,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    /// Allocate an address range within Linux system for local nodes, each of which expresses 1394
    /// OHCI hardware. Once successful, [`requested`][struct@crate::FwResp#requested] signal will be emitted whenever any
    /// request subactions arrive at the 1394 OHCI hardware within the dedicated range.
    ///
    /// The range is reserved between the values specified by @region_start and @region_end with the size
    /// indicated by @width. The starting offset may vary every time.
    /// ## `node`
    /// A [`FwNode`][crate::FwNode].
    /// ## `region_start`
    /// Start offset of address region in which range of address is looked up.
    /// ## `region_end`
    /// End offset of address region in which range of address is looked up.
    /// ## `width`
    /// The width for range of address to be looked up.
    ///
    /// # Returns
    ///
    /// TRUE if the overall operation finishes successfully, otherwise FALSE.
    #[doc(alias = "hinawa_fw_resp_reserve_within_region")]
    fn reserve_within_region(
        &self,
        node: &impl IsA<FwNode>,
        region_start: u64,
        region_end: u64,
        width: u32,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::hinawa_fw_resp_reserve_within_region(
                self.as_ref().to_glib_none().0,
                node.as_ref().to_glib_none().0,
                region_start,
                region_end,
                width,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    /// Register byte frame for the response subaction of transaction.
    /// ## `frame`
    /// a 8 bit array for response frame.
    #[doc(alias = "hinawa_fw_resp_set_resp_frame")]
    fn set_resp_frame(&self, frame: &[u8]) {
        let length = frame.len() as _;
        unsafe {
            ffi::hinawa_fw_resp_set_resp_frame(
                self.as_ref().to_glib_none().0,
                frame.to_glib_none().0,
                length,
            );
        }
    }

    /// Whether a range of address is reserved or not.
    #[doc(alias = "is-reserved")]
    fn is_reserved(&self) -> bool {
        ObjectExt::property(self.as_ref(), "is-reserved")
    }

    /// The start offset of reserved address range.
    fn offset(&self) -> u64 {
        ObjectExt::property(self.as_ref(), "offset")
    }

    /// The width of reserved address range.
    fn width(&self) -> u32 {
        ObjectExt::property(self.as_ref(), "width")
    }

    #[doc(alias = "is-reserved")]
    fn connect_is_reserved_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_reserved_trampoline<P: IsA<FwResp>, F: Fn(&P) + 'static>(
            this: *mut ffi::HinawaFwResp,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FwResp::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-reserved\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_is_reserved_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "offset")]
    fn connect_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_trampoline<P: IsA<FwResp>, F: Fn(&P) + 'static>(
            this: *mut ffi::HinawaFwResp,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FwResp::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::offset\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_offset_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "width")]
    fn connect_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_trampoline<P: IsA<FwResp>, F: Fn(&P) + 'static>(
            this: *mut ffi::HinawaFwResp,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FwResp::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<FwResp>> FwRespExt for O {}
