#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include "Auth.h"
#include <stdio.h>

void quit(void);
void check(Widget w, Prompt *prompt, int type);
Widget toplevel;

#define FOR_EDITRES

#if defined(FOR_EDITRES)
/* For editres */
extern void _XEditResCheckMessages();
#endif

void quit(void)
{
    XtDestroyWidget(toplevel);
    exit(0);
}

Widget wauthWidget;

void check(Widget w, Prompt *prompt, int type)
{
    while(prompt != NULL)
    {
	printf("Prompt: %s\nValue: %s\n\n", prompt->labeltext,
	       prompt->entrytext);
	prompt = (Prompt *)prompt->next;
    }
    if (type == LOGIN_SAFE)
	printf("Safe login..\n");

    XtVaSetValues(wauthWidget, XtNokNotify, (XtPointer)check, NULL);
    XtVaSetValues(wauthWidget, XtNabortNotify, (XtPointer)quit, NULL);

    XtVaSetValues(wauthWidget, XtNclearPrompts, True, NULL);

    XtVaSetValues(wauthWidget, XtNclearMessage, True, NULL);
    XtVaSetValues(wauthWidget, XtNmessageString, "This is a test", NULL);

    XtVaSetValues(wauthWidget, XtNaddLabelString, (XtPointer)"blah", NULL);

    XtDestroyWidget(wauthWidget);
}

void main(int argc, char **argv)
{
    XtAppContext appcontext;

    toplevel = XtAppInitialize(&appcontext, "Auth", NULL, 0,
			       &argc, argv, NULL, NULL, 0);
    wauthWidget = XtVaCreateManagedWidget("auth", authWidgetClass, 
					  toplevel,
					  XtNwidth, 350,
					  XtNheight, 250,
					  XtNbannerString, (XtPointer)"Title",
					  NULL);

    XtVaSetValues(wauthWidget, XtNokNotify, (XtPointer)check, NULL);
    XtVaSetValues(wauthWidget, XtNabortNotify, (XtPointer)quit, NULL);

    XtVaSetValues(wauthWidget, XtNaddLabelString, (XtPointer)"Hello", NULL);
    XtVaSetValues(wauthWidget, XtNaddEchoString, (XtPointer)"login", NULL);
    XtVaSetValues(wauthWidget, XtNaddNoEchoString, (XtPointer)"password",
		  NULL);

    XtVaSetValues(wauthWidget, XtNaddLabelString, (XtPointer)"Hello2", NULL);
    XtVaSetValues(wauthWidget, XtNaddEchoString, (XtPointer)"login2", NULL);
    XtVaSetValues(wauthWidget, XtNaddNoEchoString, (XtPointer)"password2",
		  NULL);

    XtVaSetValues(wauthWidget, XtNaddLabelString, (XtPointer)"Hello3", NULL);

    XtVaSetValues(toplevel, "input", True, NULL);

#if defined(FOR_EDITRES)
    /* Allows editres to work with it */
    XtAddEventHandler(toplevel, (EventMask)0, True,
		      _XEditResCheckMessages, NULL);
#endif

    XtRealizeWidget(toplevel);
    XtAppMainLoop(appcontext);
}
