/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that manipulate objects in an
 * audit record.
 */

#include "audit.h"

/* p120 - delete an object from an audit record - returns 0(success)
   -1(failure) */

int aud_delete_obj(aud_obj_t aud_obj_d)
{
    return __aud_delete_section(__AUD_MAGIC_OBJ, aud_obj_d);
}

/* p121 - delete an object data item - returns 0(success)
   -1(failure) */

int aud_delete_obj_info(aud_obj_t aud_obj_d, int item_id)
{
    return __aud_delete_section_info(__AUD_MAGIC_OBJ, aud_obj_d, item_id);
}

/* p136 - obtain a requested object in a given audit record - returns
   the non-negative number of objects recorded in this audit
   record. */

int aud_get_obj(aud_rec_t ar, int index, aud_obj_t *aud_obj_p)
{
    return __aud_get_section(__AUD_MAGIC_OBJ, ar, index,
			     (const void **) aud_obj_p);
}

/* p137 - obtain an item of data from the argument audit object -
   returns non-negative number of data items in this object. */

int aud_get_obj_info(aud_obj_t aud_obj_d, int item_id,
		     const aud_info_t **aud_obj_info_p)
{
    return __aud_get_section_info(__AUD_MAGIC_OBJ, aud_obj_d, item_id,
				  aud_obj_info_p);
}

/* p151 - add an object to audit record - returns 0(success) -1(failure) */

int aud_put_obj(aud_rec_t ar, const aud_obj_t *next_p, aud_obj_t *new_p)
{
    return __aud_put_section(__AUD_MAGIC_OBJ, ar,
			     (const struct __aud_section_s **) next_p,
			     (const struct __aud_section_s **) new_p);
}

/* p153 - add an object data item to an object record - returns
   0(success) -1(failure) */

int aud_put_obj_info(aud_obj_t aud_obj_d, int position, int item_id,
		     const aud_info_t *aud_obj_info_p)
{
    return __aud_put_section_info(__AUD_MAGIC_OBJ, aud_obj_d, position,
				  item_id, aud_obj_info_p);
}

/*
 * $Log$
 */
